/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.model.Model;
import org.eclipse.aether.ant.types.Artifact;
import org.eclipse.aether.ant.types.Pom;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectWorkspaceReader
implements WorkspaceReader {
    private static volatile ProjectWorkspaceReader instance;
    private static final Object LOCK;
    private Map<String, org.eclipse.aether.artifact.Artifact> artifacts = new ConcurrentHashMap<String, org.eclipse.aether.artifact.Artifact>();

    public void addPom(Pom pom) {
        if (pom.getFile() != null) {
            Model model = pom.getModel(pom);
            DefaultArtifact aetherArtifact = new DefaultArtifact(model.getGroupId(), model.getArtifactId(), null, "pom", model.getVersion());
            aetherArtifact = aetherArtifact.setFile(pom.getFile());
            String coords = this.coords((org.eclipse.aether.artifact.Artifact)aetherArtifact);
            this.artifacts.put(coords, (org.eclipse.aether.artifact.Artifact)aetherArtifact);
        }
    }

    public void addArtifact(Artifact artifact) {
        if (artifact.getPom() != null) {
            DefaultArtifact aetherArtifact;
            Pom pom = artifact.getPom();
            if (pom.getFile() != null) {
                Model model = pom.getModel(pom);
                aetherArtifact = new DefaultArtifact(model.getGroupId(), model.getArtifactId(), artifact.getClassifier(), artifact.getType(), model.getVersion());
            } else {
                aetherArtifact = new DefaultArtifact(pom.getGroupId(), pom.getArtifactId(), artifact.getClassifier(), artifact.getType(), pom.getVersion());
            }
            aetherArtifact = aetherArtifact.setFile(artifact.getFile());
            String coords = this.coords((org.eclipse.aether.artifact.Artifact)aetherArtifact);
            this.artifacts.put(coords, (org.eclipse.aether.artifact.Artifact)aetherArtifact);
        }
    }

    private String coords(org.eclipse.aether.artifact.Artifact artifact) {
        return ArtifactIdUtils.toId((org.eclipse.aether.artifact.Artifact)artifact);
    }

    public WorkspaceRepository getRepository() {
        return new WorkspaceRepository("ant");
    }

    public File findArtifact(org.eclipse.aether.artifact.Artifact artifact) {
        return (artifact = this.artifacts.get(this.coords(artifact))) != null ? artifact.getFile() : null;
    }

    public List<String> findVersions(org.eclipse.aether.artifact.Artifact artifact) {
        ArrayList<String> versions = new ArrayList<String>();
        for (org.eclipse.aether.artifact.Artifact art : this.artifacts.values()) {
            if (!ArtifactIdUtils.equalsVersionlessId((org.eclipse.aether.artifact.Artifact)artifact, (org.eclipse.aether.artifact.Artifact)art)) continue;
            versions.add(art.getVersion());
        }
        return versions;
    }

    ProjectWorkspaceReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectWorkspaceReader getInstance() {
        if (instance == null) {
            Object object = LOCK;
            synchronized (object) {
                if (instance == null) {
                    instance = new ProjectWorkspaceReader();
                }
            }
        }
        return instance;
    }

    static void dropInstance() {
        instance = null;
    }

    static {
        LOCK = new Object();
    }
}

