/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.ant.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;
import org.eclipse.aether.ant.types.Dependency;
import org.eclipse.aether.ant.types.Exclusion;
import org.eclipse.aether.ant.types.Pom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dependencies
extends DataType {
    private Pom pom;
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private List<Exclusion> exclusions = new ArrayList<Exclusion>();

    protected Dependencies getRef() {
        return (Dependencies)((Object)this.getCheckedRef());
    }

    public void validate(Task task) {
        if (this.isReference()) {
            this.getRef().validate(task);
        } else {
            if (this.getPom() != null && this.getPom().getFile() == null) {
                throw new BuildException("A <pom> used for dependency resolution has to be backed by a pom.xml file");
            }
            HashMap<String, String> ids = new HashMap<String, String>();
            for (Dependency dependency : this.dependencies) {
                dependency.validate(task);
                String id = dependency.getVersionlessKey();
                String collision = ids.put(id, dependency.getVersion());
                if (collision == null) continue;
                throw new BuildException("You must not declare multiple <dependency> elements with the same coordinates but got " + id + " -> " + collision + " vs " + dependency.getVersion());
            }
        }
    }

    public void setRefid(Reference ref) {
        if (this.pom != null || !this.exclusions.isEmpty() || !this.dependencies.isEmpty()) {
            throw this.noChildrenAllowed();
        }
        super.setRefid(ref);
    }

    public void addPom(Pom pom) {
        this.checkChildrenAllowed();
        if (this.pom != null) {
            throw new BuildException("You must not specify multiple <pom> elements");
        }
        this.pom = pom;
    }

    public Pom getPom() {
        if (this.isReference()) {
            return this.getRef().getPom();
        }
        return this.pom;
    }

    public void setPomRef(Reference ref) {
        if (this.pom == null) {
            this.pom = new Pom();
            this.pom.setProject(this.getProject());
        }
        this.pom.setRefid(ref);
    }

    public void addDependency(Dependency dependency) {
        this.checkChildrenAllowed();
        this.dependencies.add(dependency);
    }

    public List<Dependency> getDependencies() {
        if (this.isReference()) {
            return this.getRef().getDependencies();
        }
        return this.dependencies;
    }

    public void addExclusion(Exclusion exclusion) {
        this.checkChildrenAllowed();
        this.exclusions.add(exclusion);
    }

    public List<Exclusion> getExclusions() {
        if (this.isReference()) {
            return this.getRef().getExclusions();
        }
        return this.exclusions;
    }
}

