/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.fest.util.CollectionFilter;
import org.fest.util.ToString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Collections {
    public static <T> List<T> list(T ... elements) {
        if (elements == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T e : elements) {
            list.add(e);
        }
        return list;
    }

    public static <T> Set<T> set(T ... elements) {
        if (elements == null) {
            return null;
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T e : elements) {
            set.add(e);
        }
        return set;
    }

    public static <T> Collection<T> duplicatesFrom(Collection<T> c) {
        HashSet<T> duplicates = new HashSet<T>();
        if (Collections.isEmpty(c)) {
            return duplicates;
        }
        HashSet<T> onlyOne = new HashSet<T>();
        for (T e : c) {
            if (onlyOne.contains(e)) {
                duplicates.add(e);
                continue;
            }
            onlyOne.add(e);
        }
        return duplicates;
    }

    public static boolean isEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static <T> List<T> filter(Collection<?> target, CollectionFilter<T> filter) {
        return filter.filter(target);
    }

    public static String format(Collection<?> c) {
        if (c == null) {
            return null;
        }
        Iterator<?> i = c.iterator();
        if (!i.hasNext()) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        while (true) {
            Object e;
            b.append((e = i.next()) == c ? "(this Collection)" : ToString.toStringOf(e));
            if (!i.hasNext()) {
                return b.append(']').toString();
            }
            b.append(", ");
        }
    }

    public static <T> Collection<T> nonNullElements(Collection<T> c) {
        if (c == null) {
            return null;
        }
        ArrayList<T> nonNullElements = new ArrayList<T>();
        for (T o : c) {
            if (o == null) continue;
            nonNullElements.add(o);
        }
        return java.util.Collections.unmodifiableCollection(nonNullElements);
    }

    public static <T> List<T> nonNullElements(List<T> l) {
        Collection<T> nonNullElements = Collections.nonNullElements(l);
        if (nonNullElements == null) {
            return null;
        }
        return java.util.Collections.unmodifiableList(new ArrayList<T>(nonNullElements));
    }

    public static boolean hasOnlyNullElements(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException("The collection to check should not be null");
        }
        if (c.isEmpty()) {
            return false;
        }
        for (Object element : c) {
            if (element == null) continue;
            return false;
        }
        return true;
    }

    private Collections() {
    }
}

