/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.field;

import org.fest.reflect.field.StaticFieldType;
import org.fest.reflect.field.StaticFieldTypeRef;
import org.fest.reflect.reference.TypeRef;
import org.fest.util.Strings;

public final class StaticFieldName {
    private final String name;

    public static StaticFieldName beginStaticFieldAccess(String name) {
        StaticFieldName.validateIsNotNullOrEmpty(name);
        return new StaticFieldName(name);
    }

    private static void validateIsNotNullOrEmpty(String name) {
        if (name == null) {
            throw new NullPointerException("The name of the static field to access should not be null");
        }
        if (Strings.isEmpty((String)name)) {
            throw new IllegalArgumentException("The name of the static field to access should not be empty");
        }
    }

    private StaticFieldName(String name) {
        this.name = name;
    }

    public <T> StaticFieldType<T> ofType(Class<T> type) {
        return StaticFieldType.newFieldType(this.name, type);
    }

    public <T> StaticFieldTypeRef<T> ofType(TypeRef<T> type) {
        return StaticFieldTypeRef.newFieldTypeRef(this.name, type);
    }
}

