/*
 * Decompiled with CFR 0.152.
 */
package org.easyrules.util;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class Utils {
    private static final Logger LOGGER = Logger.getLogger(Utils.class.getName());
    public static final String DEFAULT_RULE_NAME = "rule";
    public static final String DEFAULT_ENGINE_NAME = "engine";
    public static final String DEFAULT_RULE_DESCRIPTION = "description";
    public static final int DEFAULT_RULE_PRIORITY = 0x7FFFFFFE;
    public static final int DEFAULT_RULE_PRIORITY_THRESHOLD = Integer.MAX_VALUE;

    private Utils() {
    }

    public static void muteLoggers() {
        Enumeration<String> loggerNames = LogManager.getLogManager().getLoggerNames();
        while (loggerNames.hasMoreElements()) {
            String loggerName = loggerNames.nextElement();
            if (!loggerName.startsWith("org.easyrules")) continue;
            Utils.muteLogger(loggerName);
        }
    }

    private static void muteLogger(String logger) {
        Handler[] handlers;
        Logger.getLogger(logger).setUseParentHandlers(false);
        for (Handler handler : handlers = Logger.getLogger(logger).getHandlers()) {
            Logger.getLogger(logger).removeHandler(handler);
        }
    }

    public static List<Class> getInterfaces(Object rule) {
        ArrayList<Class> interfaces = new ArrayList<Class>();
        Class<?> clazz = rule.getClass();
        while (clazz.getSuperclass() != null) {
            interfaces.addAll(Arrays.asList(clazz.getInterfaces()));
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }

    public static <A extends Annotation> A findAnnotation(Class<? extends Annotation> targetAnnotation, Class annotatedType) {
        Utils.checkNotNull(targetAnnotation, "targetAnnotation");
        Utils.checkNotNull(annotatedType, "annotatedType");
        Annotation foundAnnotation = annotatedType.getAnnotation(targetAnnotation);
        if (foundAnnotation == null) {
            for (Annotation annotation : annotatedType.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (!annotationType.isAnnotationPresent(targetAnnotation)) continue;
                foundAnnotation = annotationType.getAnnotation(targetAnnotation);
                break;
            }
        }
        return (A)foundAnnotation;
    }

    public static boolean isAnnotationPresent(Class<? extends Annotation> targetAnnotation, Class annotatedType) {
        return Utils.findAnnotation(targetAnnotation, annotatedType) != null;
    }

    public static void checkNotNull(Object argument, String argumentName) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("The %s must not be null", argumentName));
        }
    }

    static {
        try {
            if (System.getProperty("java.util.logging.config.file") == null && System.getProperty("java.util.logging.config.class") == null) {
                LogManager.getLogManager().readConfiguration(Utils.class.getResourceAsStream("/logging.properties"));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to load logging configuration file", e);
        }
    }
}

