/*
 * Decompiled with CFR 0.152.
 */
package org.easyrules.core;

import java.util.ArrayList;
import java.util.List;
import org.easyrules.api.RuleListener;
import org.easyrules.api.RulesEngine;
import org.easyrules.core.DefaultRulesEngine;
import org.easyrules.core.RulesEngineParameters;

public class RulesEngineBuilder {
    private RulesEngineParameters parameters = new RulesEngineParameters("engine", false, false, Integer.MAX_VALUE, false);
    private List<RuleListener> ruleListeners = new ArrayList<RuleListener>();

    public static RulesEngineBuilder aNewRulesEngine() {
        return new RulesEngineBuilder();
    }

    private RulesEngineBuilder() {
    }

    public RulesEngineBuilder named(String name) {
        this.parameters.setName(name);
        return this;
    }

    public RulesEngineBuilder withSkipOnFirstAppliedRule(boolean skipOnFirstAppliedRule) {
        this.parameters.setSkipOnFirstAppliedRule(skipOnFirstAppliedRule);
        return this;
    }

    public RulesEngineBuilder withSkipOnFirstFailedRule(boolean skipOnFirstFailedRule) {
        this.parameters.setSkipOnFirstFailedRule(skipOnFirstFailedRule);
        return this;
    }

    public RulesEngineBuilder withRulePriorityThreshold(int priorityThreshold) {
        this.parameters.setPriorityThreshold(priorityThreshold);
        return this;
    }

    public RulesEngineBuilder withRuleListener(RuleListener ruleListener) {
        this.ruleListeners.add(ruleListener);
        return this;
    }

    public RulesEngineBuilder withSilentMode(boolean silentMode) {
        this.parameters.setSilentMode(silentMode);
        return this;
    }

    public RulesEngine build() {
        return new DefaultRulesEngine(this.parameters, this.ruleListeners);
    }
}

