/*
 * Decompiled with CFR 0.152.
 */
package org.easyrules.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.easyrules.annotation.Action;
import org.easyrules.annotation.Condition;
import org.easyrules.annotation.Priority;
import org.easyrules.annotation.Rule;
import org.easyrules.util.Utils;

class RuleDefinitionValidator {
    RuleDefinitionValidator() {
    }

    public void validateRuleDefinition(Object rule) {
        this.checkRuleClass(rule);
        this.checkConditionMethod(rule);
        this.checkActionMethods(rule);
        this.checkPriorityMethod(rule);
    }

    private void checkRuleClass(Object rule) {
        if (!this.isRuleClassWellDefined(rule)) {
            throw new IllegalArgumentException(String.format("Rule '%s' is not annotated with '%s'", rule.getClass().getName(), Rule.class.getName()));
        }
    }

    private void checkConditionMethod(Object rule) {
        List<Method> conditionMethods = this.getMethodsAnnotatedWith(Condition.class, rule);
        if (conditionMethods.isEmpty()) {
            throw new IllegalArgumentException(String.format("Rule '%s' must have a public method annotated with '%s'", rule.getClass().getName(), Condition.class.getName()));
        }
        if (conditionMethods.size() > 1) {
            throw new IllegalArgumentException(String.format("Rule '%s' must have exactly one method annotated with '%s'", rule.getClass().getName(), Condition.class.getName()));
        }
        Method conditionMethod = conditionMethods.get(0);
        if (!this.isConditionMethodWellDefined(conditionMethod)) {
            throw new IllegalArgumentException(String.format("Condition method '%s' defined in rule '%s' must be public, have no parameters and return boolean type.", conditionMethod, rule.getClass().getName()));
        }
    }

    private void checkActionMethods(Object rule) {
        List<Method> actionMethods = this.getMethodsAnnotatedWith(Action.class, rule);
        if (actionMethods.isEmpty()) {
            throw new IllegalArgumentException(String.format("Rule '%s' must have at least one public method annotated with '%s'", rule.getClass().getName(), Action.class.getName()));
        }
        for (Method actionMethod : actionMethods) {
            if (this.isActionMethodWellDefined(actionMethod)) continue;
            throw new IllegalArgumentException(String.format("Action method '%s' defined in rule '%s' must be public and have no parameters.", actionMethod, rule.getClass().getName()));
        }
    }

    private void checkPriorityMethod(Object rule) {
        List<Method> priorityMethods = this.getMethodsAnnotatedWith(Priority.class, rule);
        if (priorityMethods.isEmpty()) {
            return;
        }
        if (priorityMethods.size() > 1) {
            throw new IllegalArgumentException(String.format("Rule '%s' must have exactly one method annotated with '%s'", rule.getClass().getName(), Priority.class.getName()));
        }
        Method priorityMethod = priorityMethods.get(0);
        if (!this.isPriorityMethodWellDefined(priorityMethod)) {
            throw new IllegalArgumentException(String.format("Priority method '%s' defined in rule '%s' must be public, have no parameters and return integer type.", priorityMethod, rule.getClass().getName()));
        }
    }

    private boolean isRuleClassWellDefined(Object rule) {
        return Utils.isAnnotationPresent(Rule.class, rule.getClass());
    }

    private boolean isConditionMethodWellDefined(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getReturnType().equals(Boolean.TYPE) && method.getParameterTypes().length == 0;
    }

    private boolean isActionMethodWellDefined(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 0;
    }

    private boolean isPriorityMethodWellDefined(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getReturnType().equals(Integer.TYPE) && method.getParameterTypes().length == 0;
    }

    private List<Method> getMethodsAnnotatedWith(Class<? extends Annotation> annotation, Object rule) {
        Method[] methods = this.getMethods(rule);
        ArrayList<Method> annotatedMethods = new ArrayList<Method>();
        for (Method method : methods) {
            if (!method.isAnnotationPresent(annotation)) continue;
            annotatedMethods.add(method);
        }
        return annotatedMethods;
    }

    private Method[] getMethods(Object rule) {
        return rule.getClass().getMethods();
    }
}

