/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.time.DateUtils;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.easetech.easytest.internal.DateTimeFormat;
import org.junit.experimental.theories.PotentialAssignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralUtil {
    private static final Logger LOG = LoggerFactory.getLogger(GeneralUtil.class);
    private static final String FILE_SEPARATOR = String.valueOf(File.separatorChar);
    private static final String NULL_STR = "null";
    private static final String EMPTY_STRING = "";
    private static final String COLON = ":";
    private static final Pattern OBJECT_PATTERN = Pattern.compile("\\{.*\\}");
    private static final Pattern ARRAY_PATTERN = Pattern.compile("\\[.*\\]");

    public static Double getRounded(double valueToRound, int numberOfDecimalPlaces) {
        BigDecimal bigDecimal = new BigDecimal(valueToRound).setScale(numberOfDecimalPlaces, RoundingMode.HALF_UP);
        return bigDecimal.doubleValue();
    }

    public static String getStringValue(String paramName, Map<String, Object> data) {
        return data.get(paramName) != null && !data.get(paramName).equals(NULL_STR) ? data.get(paramName).toString() : null;
    }

    public static String createDefaultOutputFolder(String destinationFolder) {
        if (destinationFolder == null || destinationFolder.equals(EMPTY_STRING)) {
            destinationFolder = System.getProperty("user.dir") + File.separatorChar + "target" + File.separatorChar + "reports";
        }
        return GeneralUtil.createFolder(destinationFolder);
    }

    public static String getCurrentFolder() {
        File file = new File(EMPTY_STRING);
        String absolutePath = file.getAbsolutePath();
        return absolutePath;
    }

    public static String createFolder(String absoluteLocation) {
        if (absoluteLocation == null) {
            return null;
        }
        File file = new File(absoluteLocation);
        if (!file.isDirectory()) {
            try {
                FileUtils.forceMkdir((File)file);
            }
            catch (IOException e) {
                LOG.error("Error creating directory " + absoluteLocation + " (" + e.getMessage() + ")");
            }
        }
        return absoluteLocation;
    }

    public static String getAbsoluteLocation(String location) {
        String path = null;
        if (location.equals(EMPTY_STRING)) {
            return GeneralUtil.getCurrentFolder();
        }
        if (location.startsWith("file:")) {
            path = location.substring(location.indexOf(COLON) + 1, location.length());
        } else if (location.startsWith("classpath:")) {
            path = location.substring(location.indexOf(COLON) + 1, location.length());
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL url = classLoader.getResource(".");
            try {
                File file = new File(url.toURI());
                String tempPath = file.toString();
                if (!tempPath.endsWith(FILE_SEPARATOR)) {
                    tempPath = tempPath + FILE_SEPARATOR;
                }
                path = path.replace("/", FILE_SEPARATOR);
                path = tempPath + path;
            }
            catch (URISyntaxException e) {
                LOG.error("URI exception ", (Throwable)e);
            }
        } else {
            LOG.error("Report output location " + location + " not found");
        }
        return path;
    }

    public static Timestamp convertToSQLTimestamp(Object object, DateTimeFormat dateTimeFormat) {
        Timestamp timestamp = null;
        if (object != null && !object.toString().isEmpty()) {
            timestamp = new Timestamp(GeneralUtil.convertToUtilDate(object, dateTimeFormat).getTime());
        }
        return timestamp;
    }

    public static java.util.Date convertToUtilDate(Object object, DateTimeFormat dateTimeFormat) {
        java.util.Date date = null;
        if (object != null && !object.toString().isEmpty()) {
            if (object instanceof java.util.Date) {
                date = (java.util.Date)object;
            } else if (object instanceof Double) {
                date = new java.util.Date(((Double)object).longValue());
            } else if (object instanceof String) {
                try {
                    Object[] formats = (String[])ArrayUtils.addAll((Object[])dateTimeFormat.getDateTimeFormat(), (Object[])dateTimeFormat.getDateFormat());
                    String[] availableFormats = (String[])ArrayUtils.addAll((Object[])formats, (Object[])dateTimeFormat.getTimeFormat());
                    date = DateUtils.parseDate((String)((String)object), (String[])availableFormats);
                }
                catch (ParseException e) {
                    LOG.error("Parse exception occured while trying to convert {} to java util date using formats {}", object, (Object)dateTimeFormat);
                    throw new RuntimeException(e);
                }
            }
        }
        return date;
    }

    public static Date convertToSQLDate(Object object, DateTimeFormat dateTimeFormat) {
        Date sqlDate = null;
        if (object != null && !object.toString().isEmpty()) {
            sqlDate = new Date(GeneralUtil.convertToUtilDate(object, dateTimeFormat).getTime());
        }
        return sqlDate;
    }

    public static Time convertToSQLTime(Object object, DateTimeFormat dateTimeFormat) {
        Time time = null;
        if (object != null && !object.toString().isEmpty()) {
            if (object instanceof java.util.Date) {
                time = new Time(((java.util.Date)object).getTime());
            } else if (object instanceof Double) {
                time = new Time(((Double)object).longValue());
            } else if (object instanceof String) {
                java.util.Date date;
                try {
                    date = DateUtils.parseDate((String)((String)object), (String[])dateTimeFormat.getTimeFormat());
                }
                catch (ParseException e) {
                    LOG.debug("Parse Exception occured while trying to convert to SQL TimeStamp. The object to convert to : {} and the fomat used to convert to SQL Time : {}", object, (Object)dateTimeFormat.getTimeFormat());
                    date = new java.util.Date(Long.valueOf((String)object));
                }
                time = new Time(date.getTime());
            }
        }
        return time;
    }

    public static Integer convertToInteger(Object object) {
        Integer integer = null;
        if (object != null && !object.toString().isEmpty()) {
            if (object instanceof Long) {
                integer = ((Long)object).intValue();
            } else if (object instanceof Integer) {
                integer = (Integer)object;
            } else if (object instanceof Double) {
                integer = ((Double)object).intValue();
            } else if (object instanceof String) {
                integer = Integer.valueOf((String)object);
            }
        }
        return integer;
    }

    public static Short convertToShort(Object object) {
        Short shortValue = null;
        if (object != null && !object.toString().isEmpty()) {
            if (object instanceof Long) {
                shortValue = ((Long)object).shortValue();
            } else if (object instanceof Integer) {
                shortValue = ((Integer)object).shortValue();
            } else if (object instanceof Double) {
                shortValue = ((Double)object).shortValue();
            } else if (object instanceof String) {
                shortValue = Short.valueOf((String)object);
            }
        }
        return shortValue;
    }

    public static Long convertToLong(Object object) {
        Long longvalue = null;
        if (object != null) {
            String strLongValue;
            if (object instanceof Long) {
                longvalue = (long)((Long)object);
            } else if (object instanceof Integer) {
                longvalue = ((Integer)object).longValue();
            } else if (object instanceof Double) {
                longvalue = ((Double)object).longValue();
            } else if (object instanceof String && !EMPTY_STRING.equalsIgnoreCase(strLongValue = (String)object)) {
                longvalue = Long.valueOf((String)object);
            }
        }
        return longvalue;
    }

    public static Double convertToDouble(Object object) {
        Double doublevalue = null;
        if (object != null && !object.toString().isEmpty()) {
            if (object instanceof Long) {
                doublevalue = ((Long)object).doubleValue();
            } else if (object instanceof Integer) {
                doublevalue = ((Integer)object).doubleValue();
            } else if (object instanceof Double) {
                doublevalue = (double)((Double)object);
            } else if (object instanceof String && !EMPTY_STRING.equals((String)object)) {
                doublevalue = Double.valueOf((String)object);
            }
        }
        return doublevalue;
    }

    public static Float convertToFloat(Object object) {
        Float floatvalue = null;
        if (object != null && !object.toString().isEmpty()) {
            if (object instanceof Long) {
                floatvalue = Float.valueOf(((Long)object).floatValue());
            } else if (object instanceof Integer) {
                floatvalue = Float.valueOf(((Integer)object).floatValue());
            } else if (object instanceof Double) {
                floatvalue = Float.valueOf(((Double)object).floatValue());
            } else if (object instanceof String && !EMPTY_STRING.equals((String)object)) {
                floatvalue = Float.valueOf((String)object);
            }
        }
        return floatvalue;
    }

    public static Boolean convertToBoolean(Object object) {
        Boolean booleanValue = null;
        if (object != null && !object.toString().isEmpty()) {
            if (object instanceof Long) {
                booleanValue = GeneralUtil.stringToBoolean(((Long)object).toString());
            } else if (object instanceof Integer) {
                booleanValue = GeneralUtil.stringToBoolean(((Integer)object).toString());
            } else if (object instanceof Double) {
                booleanValue = GeneralUtil.stringToBoolean(((Double)object).toString());
            } else if (object instanceof String && !EMPTY_STRING.equals((String)object)) {
                booleanValue = GeneralUtil.stringToBoolean((String)object);
            }
        }
        return booleanValue;
    }

    public static Byte convertToByte(Object object) {
        Byte byteValue = null;
        if (object != null && !object.toString().isEmpty()) {
            if (object instanceof Long) {
                byteValue = Byte.valueOf(((Long)object).toString());
            } else if (object instanceof Integer) {
                byteValue = Byte.valueOf(((Integer)object).toString());
            } else if (object instanceof Double) {
                byteValue = Byte.valueOf(((Double)object).toString());
            } else if (object instanceof String && !EMPTY_STRING.equals((String)object)) {
                byteValue = Byte.valueOf((String)object);
            }
        }
        return byteValue;
    }

    public static Character convertToCharacter(Object object) {
        Character chValue = null;
        if (object != null && !object.toString().isEmpty()) {
            if (object instanceof Long) {
                chValue = Character.valueOf((char)((Long)object).longValue());
            } else if (object instanceof Integer) {
                chValue = Character.valueOf((char)((Integer)object).intValue());
            } else if (object instanceof Double) {
                chValue = Character.valueOf((char)((Double)object).doubleValue());
            } else if (object instanceof String && !EMPTY_STRING.equals((String)object)) {
                chValue = Character.valueOf(((String)object).charAt(0));
            } else if (object instanceof Character) {
                chValue = (Character)object;
            }
        }
        return chValue;
    }

    public static String convertToString(Object object) {
        return object == null ? null : object.toString();
    }

    public static StringBuffer convertToStringBuffer(Object object) {
        return object == null ? null : new StringBuffer(object.toString());
    }

    public static StringBuilder convertToStringBuilder(Object object) {
        return object == null ? null : new StringBuilder(object.toString());
    }

    public static Enum convertToEnum(Class idClass, Object object) {
        Enum enumValue = null;
        if (object != null && idClass.isEnum()) {
            enumValue = (Enum)Enum.valueOf(idClass, GeneralUtil.convertToString(object));
        }
        return enumValue;
    }

    private static Boolean stringToBoolean(String str) {
        Boolean value = null;
        if (str != null) {
            value = str.equalsIgnoreCase("True") ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return value;
    }

    public static Boolean dataAlreadyConverted(Class parameterType, List<Map<String, Object>> convertFrom, String paramName) {
        Boolean result;
        block0: {
            Map<String, Object> data;
            Object value;
            result = false;
            Iterator<Map<String, Object>> i$ = convertFrom.iterator();
            if (!i$.hasNext() || (value = (data = i$.next()).get(paramName)) == null || !parameterType.isAssignableFrom(value.getClass())) break block0;
            result = true;
        }
        return result;
    }

    public static Object convertToTargetType(Class<?> idClass, Object object, Boolean convertEmptyToNull, DateTimeFormat dateTimeFormat) {
        Object returnObj = null;
        if (object == null || NULL_STR.equals(object.toString())) {
            return null;
        }
        if (convertEmptyToNull.booleanValue() && EMPTY_STRING.equals(object.toString())) {
            return null;
        }
        if (String.class.isAssignableFrom(idClass)) {
            returnObj = GeneralUtil.convertToString(object);
        } else if (Timestamp.class.isAssignableFrom(idClass)) {
            returnObj = GeneralUtil.convertToSQLTimestamp(object, dateTimeFormat);
        } else if (Time.class.isAssignableFrom(idClass)) {
            returnObj = GeneralUtil.convertToSQLTime(object, dateTimeFormat);
        } else if (Date.class.isAssignableFrom(idClass)) {
            returnObj = GeneralUtil.convertToSQLDate(object, dateTimeFormat);
        } else if (java.util.Date.class.isAssignableFrom(idClass)) {
            returnObj = GeneralUtil.convertToUtilDate(object, dateTimeFormat);
        } else if (Double.class.isAssignableFrom(idClass) || Double.TYPE.isAssignableFrom(idClass)) {
            returnObj = GeneralUtil.convertToDouble(object);
        } else if (Float.class.isAssignableFrom(idClass) || Float.TYPE.isAssignableFrom(idClass)) {
            returnObj = GeneralUtil.convertToFloat(object);
        } else if (Long.class.isAssignableFrom(idClass) || Long.TYPE.isAssignableFrom(idClass)) {
            returnObj = GeneralUtil.convertToLong(object);
        } else if (Integer.class.isAssignableFrom(idClass) || Integer.TYPE.isAssignableFrom(idClass)) {
            returnObj = GeneralUtil.convertToInteger(object);
        } else if (Boolean.class.isAssignableFrom(idClass) || Boolean.TYPE.isAssignableFrom(idClass)) {
            returnObj = GeneralUtil.convertToBoolean(object);
        } else if (Byte.class.isAssignableFrom(idClass) || Byte.TYPE.isAssignableFrom(idClass)) {
            returnObj = GeneralUtil.convertToByte(object);
        } else if (Character.class.isAssignableFrom(idClass) || Character.TYPE.isAssignableFrom(idClass)) {
            returnObj = GeneralUtil.convertToCharacter(object);
        } else if (Short.class.isAssignableFrom(idClass) || Short.TYPE.isAssignableFrom(idClass)) {
            returnObj = GeneralUtil.convertToShort(object);
        } else if (Enum.class.isAssignableFrom(idClass)) {
            returnObj = GeneralUtil.convertToEnum(idClass, object);
        } else if (StringBuffer.class.isAssignableFrom(idClass)) {
            returnObj = GeneralUtil.convertToStringBuffer(object);
        } else if (StringBuilder.class.isAssignableFrom(idClass)) {
            returnObj = GeneralUtil.convertToStringBuilder(object);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not find either Editor or Converter instance for class :" + idClass);
            }
            Assert.fail((String)("Could not find either Editor or Converter instance for class :" + idClass));
        }
        return returnObj;
    }

    public static boolean isStandardObjectInstance(Class<?> idClass) {
        boolean result = false;
        if (String.class.isAssignableFrom(idClass) || Timestamp.class.isAssignableFrom(idClass) || Time.class.isAssignableFrom(idClass) || Date.class.isAssignableFrom(idClass) || java.util.Date.class.isAssignableFrom(idClass) || Double.class.isAssignableFrom(idClass) || Double.TYPE.isAssignableFrom(idClass) || Float.class.isAssignableFrom(idClass) || Float.TYPE.isAssignableFrom(idClass) || Long.class.isAssignableFrom(idClass) || Long.TYPE.isAssignableFrom(idClass) || Integer.class.isAssignableFrom(idClass) || Integer.TYPE.isAssignableFrom(idClass) || Boolean.class.isAssignableFrom(idClass) || Boolean.TYPE.isAssignableFrom(idClass) || Byte.class.isAssignableFrom(idClass) || Byte.TYPE.isAssignableFrom(idClass) || Character.class.isAssignableFrom(idClass) || Character.TYPE.isAssignableFrom(idClass) || Short.class.isAssignableFrom(idClass) || Short.TYPE.isAssignableFrom(idClass) || Enum.class.isAssignableFrom(idClass) || StringBuffer.class.isAssignableFrom(idClass) || StringBuilder.class.isAssignableFrom(idClass)) {
            result = true;
        }
        return result;
    }

    public static Boolean populateJSONData(Class<?> idClass, List<Map<String, Object>> convertFrom, List<PotentialAssignment> potentialAssignments, String paramName) {
        Boolean result = false;
        Object value = null;
        for (Map<String, Object> object : convertFrom) {
            if (paramName != null && !EMPTY_STRING.equals(paramName)) {
                value = object.get(paramName);
                if (value == null || !GeneralUtil.isJSON(value.toString()).booleanValue()) continue;
                GeneralUtil.handleJSONData(value.toString(), idClass, potentialAssignments);
                result = true;
                continue;
            }
            value = object.get(idClass.getSimpleName());
            if (value == null || !GeneralUtil.isJSON(value.toString()).booleanValue()) continue;
            GeneralUtil.handleJSONData(value.toString(), idClass, potentialAssignments);
            result = true;
        }
        return result;
    }

    public static <T> void handleJSONData(String expr, Class<T> idClass, List<PotentialAssignment> potentialAssignments) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Object value = mapper.readValue(expr, idClass);
            potentialAssignments.add(PotentialAssignment.forValue((String)EMPTY_STRING, (Object)value));
        }
        catch (JsonParseException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Boolean isJSON(String expression) {
        if (expression == null || EMPTY_STRING.equals(expression)) {
            return false;
        }
        Matcher objectMatcher = OBJECT_PATTERN.matcher(expression);
        Matcher arrayMatcher = ARRAY_PATTERN.matcher(expression);
        if (objectMatcher.matches() || arrayMatcher.matches()) {
            return true;
        }
        return false;
    }

    public static Boolean fillDataUsingConstructor(Class<?> idClass, List<Map<String, Object>> convertFrom, List<PotentialAssignment> finalData, String paramName, Collection collectionInstance, Boolean convertEmptyToNull, DateTimeFormat dateTimeFormat) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor constructor;
        Constructor constructor2 = constructor = GeneralUtil.getConstructor(idClass, Long.class) == null ? GeneralUtil.getConstructor(idClass, Long.TYPE) : GeneralUtil.getConstructor(idClass, Long.class);
        if (constructor != null) {
            GeneralUtil.fill(idClass, paramName, constructor, finalData, convertFrom, Long.class, collectionInstance, convertEmptyToNull, dateTimeFormat);
        } else {
            constructor = GeneralUtil.getConstructor(idClass, String.class);
            if (constructor != null) {
                GeneralUtil.fill(idClass, paramName, constructor, finalData, convertFrom, String.class, collectionInstance, convertEmptyToNull, dateTimeFormat);
            } else {
                constructor = GeneralUtil.getConstructor(idClass, Integer.class) == null ? GeneralUtil.getConstructor(idClass, Integer.TYPE) : GeneralUtil.getConstructor(idClass, Integer.class);
                if (constructor != null) {
                    GeneralUtil.fill(idClass, paramName, constructor, finalData, convertFrom, Integer.class, collectionInstance, convertEmptyToNull, dateTimeFormat);
                } else {
                    constructor = GeneralUtil.getConstructor(idClass, Byte.class) == null ? GeneralUtil.getConstructor(idClass, Byte.TYPE) : GeneralUtil.getConstructor(idClass, Byte.class);
                    if (constructor != null) {
                        GeneralUtil.fill(idClass, paramName, constructor, finalData, convertFrom, Byte.class, collectionInstance, convertEmptyToNull, dateTimeFormat);
                    } else {
                        constructor = GeneralUtil.getConstructor(idClass, Character.class) == null ? GeneralUtil.getConstructor(idClass, Character.TYPE) : GeneralUtil.getConstructor(idClass, Character.class);
                        if (constructor != null) {
                            GeneralUtil.fill(idClass, paramName, constructor, finalData, convertFrom, Character.class, collectionInstance, convertEmptyToNull, dateTimeFormat);
                        } else {
                            constructor = GeneralUtil.getConstructor(idClass, java.util.Date.class);
                            if (constructor != null) {
                                GeneralUtil.fill(idClass, paramName, constructor, finalData, convertFrom, java.util.Date.class, collectionInstance, convertEmptyToNull, dateTimeFormat);
                            } else {
                                constructor = GeneralUtil.getConstructor(idClass, java.util.Date.class);
                                if (constructor != null) {
                                    GeneralUtil.fill(idClass, paramName, constructor, finalData, convertFrom, java.util.Date.class, collectionInstance, convertEmptyToNull, dateTimeFormat);
                                } else {
                                    constructor = GeneralUtil.getConstructor(idClass, Timestamp.class);
                                    if (constructor != null) {
                                        GeneralUtil.fill(idClass, paramName, constructor, finalData, convertFrom, Timestamp.class, collectionInstance, convertEmptyToNull, dateTimeFormat);
                                    } else {
                                        constructor = GeneralUtil.getConstructor(idClass, Time.class);
                                        if (constructor != null) {
                                            GeneralUtil.fill(idClass, paramName, constructor, finalData, convertFrom, Time.class, collectionInstance, convertEmptyToNull, dateTimeFormat);
                                        } else {
                                            constructor = GeneralUtil.getConstructor(idClass, Double.class) == null ? GeneralUtil.getConstructor(idClass, Double.TYPE) : GeneralUtil.getConstructor(idClass, Double.class);
                                            if (constructor != null) {
                                                GeneralUtil.fill(idClass, paramName, constructor, finalData, convertFrom, Double.class, collectionInstance, convertEmptyToNull, dateTimeFormat);
                                            } else {
                                                constructor = GeneralUtil.getConstructor(idClass, Float.class) == null ? GeneralUtil.getConstructor(idClass, Float.TYPE) : GeneralUtil.getConstructor(idClass, Float.class);
                                                if (constructor != null) {
                                                    GeneralUtil.fill(idClass, paramName, constructor, finalData, convertFrom, Float.class, collectionInstance, convertEmptyToNull, dateTimeFormat);
                                                } else {
                                                    constructor = GeneralUtil.getConstructor(idClass, Boolean.class) == null ? GeneralUtil.getConstructor(idClass, Boolean.TYPE) : GeneralUtil.getConstructor(idClass, Boolean.class);
                                                    if (constructor != null) {
                                                        GeneralUtil.fill(idClass, paramName, constructor, finalData, convertFrom, Boolean.class, collectionInstance, convertEmptyToNull, dateTimeFormat);
                                                    } else {
                                                        constructor = GeneralUtil.getConstructor(idClass, Short.class) == null ? GeneralUtil.getConstructor(idClass, Short.TYPE) : GeneralUtil.getConstructor(idClass, Boolean.class);
                                                        if (constructor != null) {
                                                            GeneralUtil.fill(idClass, paramName, constructor, finalData, convertFrom, Short.class, collectionInstance, convertEmptyToNull, dateTimeFormat);
                                                        } else {
                                                            constructor = GeneralUtil.getConstructor(idClass, Enum.class);
                                                            if (constructor != null) {
                                                                GeneralUtil.fill(idClass, paramName, constructor, finalData, convertFrom, Enum.class, collectionInstance, convertEmptyToNull, dateTimeFormat);
                                                            } else {
                                                                return false;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    private static <T> Boolean fill(Class idClass, String paramName, Constructor constructor, List<PotentialAssignment> finalData, List<Map<String, Object>> convertFrom, Class<T> argType, Collection collectionInstance, Boolean convertEmptyToNull, DateTimeFormat dateTimeFormat) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (GeneralUtil.isStandardObjectInstance(argType)) {
            for (Map<String, Object> object : convertFrom) {
                Object target = null;
                Object result = null;
                if (collectionInstance != null) {
                    GeneralUtil.fillCollectionData(idClass, object, paramName, constructor, finalData, argType, collectionInstance, convertEmptyToNull, dateTimeFormat);
                    continue;
                }
                GeneralUtil.fillData(idClass, object, paramName, constructor, finalData, argType, convertEmptyToNull, dateTimeFormat);
            }
            return true;
        }
        return false;
    }

    private static <T> void fillCollectionData(Class<?> idClass, Map<String, Object> object, String paramName, Constructor constructor, List<PotentialAssignment> finalData, Class<T> argType, Collection collectionInstance, Boolean convertEmptyToNull, DateTimeFormat dateTimeFormat) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object result = null;
        Object target = null;
        if (paramName != null && !EMPTY_STRING.equals(paramName)) {
            String[] strValues = ((String)object.get(paramName)).split(COLON);
            for (int i = 0; i < strValues.length; ++i) {
                target = GeneralUtil.convertToTargetType(argType, strValues[i], convertEmptyToNull, dateTimeFormat);
                result = constructor.newInstance(target);
                collectionInstance.add(result);
            }
            finalData.add(PotentialAssignment.forValue((String)EMPTY_STRING, (Object)collectionInstance));
        } else {
            String[] strValues = ((String)object.get(idClass.getSimpleName())).split(COLON);
            for (int i = 0; i < strValues.length; ++i) {
                target = GeneralUtil.convertToTargetType(argType, strValues[i], convertEmptyToNull, dateTimeFormat);
                result = constructor.newInstance(target);
                collectionInstance.add(result);
            }
            finalData.add(PotentialAssignment.forValue((String)EMPTY_STRING, (Object)collectionInstance));
        }
    }

    private static <T> void fillData(Class<?> idClass, Map<String, Object> object, String paramName, Constructor constructor, List<PotentialAssignment> finalData, Class<T> argType, Boolean convertEmptyToNull, DateTimeFormat dateTimeFormat) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object result = null;
        Object target = null;
        if (paramName != null && !EMPTY_STRING.equals(paramName)) {
            target = GeneralUtil.convertToTargetType(argType, object.get(paramName), convertEmptyToNull, dateTimeFormat);
            result = constructor.newInstance(target);
            finalData.add(PotentialAssignment.forValue((String)EMPTY_STRING, result));
        } else {
            result = constructor.newInstance(GeneralUtil.convertToTargetType(argType, object.get(idClass.getSimpleName()), convertEmptyToNull, dateTimeFormat));
            finalData.add(PotentialAssignment.forValue((String)EMPTY_STRING, result));
        }
    }

    private static Constructor getConstructor(Class<?> idClass, Class<?> paramType) {
        Constructor<?> constructor = null;
        try {
            constructor = idClass.getConstructor(paramType);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return constructor;
    }

    public static Constructor getConstructor(Class<?> idClass) {
        Constructor constructor;
        Constructor constructor2 = constructor = GeneralUtil.getConstructor(idClass, Long.class) == null ? GeneralUtil.getConstructor(idClass, Long.TYPE) : GeneralUtil.getConstructor(idClass, Long.class);
        if (constructor != null) {
            return constructor;
        }
        constructor = GeneralUtil.getConstructor(idClass, String.class);
        if (constructor != null) {
            return constructor;
        }
        constructor = GeneralUtil.getConstructor(idClass, Integer.class) == null ? GeneralUtil.getConstructor(idClass, Integer.TYPE) : GeneralUtil.getConstructor(idClass, Integer.class);
        if (constructor != null) {
            return constructor;
        }
        constructor = GeneralUtil.getConstructor(idClass, Byte.class) == null ? GeneralUtil.getConstructor(idClass, Byte.TYPE) : GeneralUtil.getConstructor(idClass, Byte.class);
        if (constructor != null) {
            return constructor;
        }
        constructor = GeneralUtil.getConstructor(idClass, Character.class) == null ? GeneralUtil.getConstructor(idClass, Character.TYPE) : GeneralUtil.getConstructor(idClass, Character.class);
        if (constructor != null) {
            return constructor;
        }
        constructor = GeneralUtil.getConstructor(idClass, java.util.Date.class);
        if (constructor != null) {
            return constructor;
        }
        constructor = GeneralUtil.getConstructor(idClass, java.util.Date.class);
        if (constructor != null) {
            return constructor;
        }
        constructor = GeneralUtil.getConstructor(idClass, Timestamp.class);
        if (constructor != null) {
            return constructor;
        }
        constructor = GeneralUtil.getConstructor(idClass, Time.class);
        if (constructor != null) {
            return constructor;
        }
        constructor = GeneralUtil.getConstructor(idClass, Double.class) == null ? GeneralUtil.getConstructor(idClass, Double.TYPE) : GeneralUtil.getConstructor(idClass, Double.class);
        if (constructor != null) {
            return constructor;
        }
        constructor = GeneralUtil.getConstructor(idClass, Float.class) == null ? GeneralUtil.getConstructor(idClass, Float.TYPE) : GeneralUtil.getConstructor(idClass, Float.class);
        if (constructor != null) {
            return constructor;
        }
        constructor = GeneralUtil.getConstructor(idClass, Boolean.class) == null ? GeneralUtil.getConstructor(idClass, Boolean.TYPE) : GeneralUtil.getConstructor(idClass, Boolean.class);
        if (constructor != null) {
            return constructor;
        }
        constructor = GeneralUtil.getConstructor(idClass, Short.class) == null ? GeneralUtil.getConstructor(idClass, Short.TYPE) : GeneralUtil.getConstructor(idClass, Boolean.class);
        if (constructor != null) {
            return constructor;
        }
        constructor = GeneralUtil.getConstructor(idClass, Enum.class);
        if (constructor != null) {
            return constructor;
        }
        return null;
    }
}

