/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataContext {
    public static final InheritableThreadLocal<Map<String, List<Map<String, Object>>>> convertedDataThreadLocal = new InheritableThreadLocal();
    public static final InheritableThreadLocal<Map<String, List<Map<String, Object>>>> dataContextThreadLocal = new InheritableThreadLocal();

    private DataContext() {
    }

    public static void setData(Map<String, List<Map<String, Object>>> data, Boolean appendData) {
        Map testData = (Map)dataContextThreadLocal.get();
        if (testData == null || testData.isEmpty()) {
            dataContextThreadLocal.set(data);
        } else {
            if (appendData.booleanValue()) {
                for (String key : data.keySet()) {
                    List<Map<String, Object>> availableData = (List<Map<String, Object>>)testData.get(key);
                    if (availableData != null) {
                        availableData.addAll((Collection<Map<String, Object>>)data.get(key));
                    } else {
                        availableData = data.get(key);
                    }
                    testData.put(key, availableData);
                }
            } else {
                for (String key : data.keySet()) {
                    testData.put(key, data.get(key));
                }
            }
            dataContextThreadLocal.set(testData);
        }
    }

    public static void setConvertedData(Map<String, List<Map<String, Object>>> data, Boolean appendData) {
        Map testData = (Map)convertedDataThreadLocal.get();
        if (testData == null || testData.isEmpty()) {
            convertedDataThreadLocal.set(data);
        } else {
            if (appendData.booleanValue()) {
                for (String key : data.keySet()) {
                    testData.put(key, data.get(key));
                }
            } else {
                boolean removedOldKeys = false;
                for (String key : data.keySet()) {
                    if (!removedOldKeys) {
                        String newKeyMethod = key.substring(0, key.indexOf("{"));
                        Iterator testDataItr = testData.entrySet().iterator();
                        while (testDataItr.hasNext()) {
                            Map.Entry entry = testDataItr.next();
                            String oldKey = (String)entry.getKey();
                            String oldKeyMethod = oldKey.substring(0, oldKey.indexOf("{"));
                            if (oldKeyMethod.equals(newKeyMethod)) {
                                testDataItr.remove();
                            }
                            removedOldKeys = true;
                        }
                    }
                    testData.put(key, data.get(key));
                }
            }
            convertedDataThreadLocal.set(testData);
        }
    }

    public static Map<String, List<Map<String, Object>>> getConvertedData() {
        return (Map)convertedDataThreadLocal.get();
    }

    public static Map<String, List<Map<String, Object>>> getData() {
        return (Map)dataContextThreadLocal.get();
    }

    public static void clearData() {
        dataContextThreadLocal.remove();
    }

    public static void clearConvertedData() {
        convertedDataThreadLocal.remove();
    }

    public static void cleanData() {
        DataContext.clearData();
        DataContext.clearConvertedData();
    }
}

