/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.runner;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.internal.EasyAssignments;
import org.easetech.easytest.reports.data.TestMethodDuration;
import org.easetech.easytest.reports.data.TestResultBean;
import org.easetech.easytest.runner.EasyFrameworkMethod;
import org.easetech.easytest.runner.TestRunDurationListener;
import org.easetech.easytest.util.CommonUtils;
import org.junit.Assert;
import org.junit.experimental.theories.PotentialAssignment;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalParameterizedStatement
extends Statement {
    private final Statement originalStatement;
    protected final Logger LOG = LoggerFactory.getLogger(InternalParameterizedStatement.class);
    private EasyFrameworkMethod fTestMethod;
    private List<EasyAssignments> listOfAssignments;
    private List<AssumptionViolatedException> fInvalidParameters = new ArrayList<AssumptionViolatedException>();
    private TestClass fTestClass;
    private Object testInstance;

    public InternalParameterizedStatement(Statement originalStatement, EasyFrameworkMethod fTestMethod, TestClass testClass, Object testInstance) {
        this.fTestMethod = fTestMethod;
        this.listOfAssignments = new ArrayList<EasyAssignments>();
        this.fTestClass = testClass;
        this.testInstance = testInstance;
        this.originalStatement = originalStatement;
    }

    private TestClass getTestClass() {
        return this.fTestClass;
    }

    public void evaluate() throws Throwable {
        if (this.originalStatement != null) {
            this.originalStatement.evaluate();
        }
        this.runWithAssignment(EasyAssignments.allUnassigned(this.fTestMethod.getMethod(), this.getTestClass()));
    }

    protected void runWithAssignment(EasyAssignments parameterAssignment) throws Throwable {
        while (!parameterAssignment.isComplete()) {
            List<PotentialAssignment> potentialAssignments = parameterAssignment.potentialsForNextUnassigned(this.fTestMethod);
            boolean isFirstSetOfArguments = this.listOfAssignments.isEmpty();
            for (int i = 0; i < potentialAssignments.size(); ++i) {
                EasyAssignments assignments;
                if (isFirstSetOfArguments) {
                    assignments = EasyAssignments.allUnassigned(this.fTestMethod.getMethod(), this.getTestClass());
                    this.listOfAssignments.add(assignments.assignNext(potentialAssignments.get(i)));
                    continue;
                }
                assignments = this.listOfAssignments.get(i);
                try {
                    this.listOfAssignments.set(i, assignments.assignNext(potentialAssignments.get(i)));
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    this.listOfAssignments.add(assignments.assignNext(potentialAssignments.get(i)));
                }
            }
            parameterAssignment = parameterAssignment.assignNext(null);
        }
        if (this.listOfAssignments.isEmpty()) {
            this.LOG.debug("The list of Assignments is null. It normally happens when the user has not supplied any parameters to the test.");
            this.LOG.debug(" Creating an instance of Assignments object with all its value unassigned.");
            this.listOfAssignments.add(EasyAssignments.allUnassigned(this.fTestMethod.getMethod(), this.getTestClass()));
        }
        for (EasyAssignments assignments : this.listOfAssignments) {
            this.runWithCompleteAssignment(assignments);
        }
    }

    protected void runWithCompleteAssignment(EasyAssignments complete) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, Throwable {
        this.methodCompletesWithParameters(this.fTestMethod, complete, this.testInstance);
    }

    private void methodCompletesWithParameters(EasyFrameworkMethod method, EasyAssignments complete, Object freshInstance) throws Throwable {
        RunNotifier testRunNotifier = new RunNotifier();
        TestRunDurationListener testRunDurationListener = new TestRunDurationListener();
        testRunNotifier.addListener((RunListener)testRunDurationListener);
        EachTestNotifier eachRunNotifier = new EachTestNotifier(testRunNotifier, null);
        String currentMethodName = method.getMethod().getName();
        TestResultBean testResult = method.getTestResult();
        Map<String, Object> writableRow = method.getTestData();
        Object returnObj = null;
        try {
            Object[] values = complete.getMethodArguments(true);
            testResult.setInput(method.getTestData());
            eachRunNotifier.fireTestStarted();
            this.LOG.debug("Calling method {} with values {}", (Object)method.getName(), (Object)values);
            returnObj = method.invokeExplosively(freshInstance, values);
            eachRunNotifier.fireTestFinished();
            TestMethodDuration testItemDurationBean = new TestMethodDuration(currentMethodName, testRunDurationListener.getStartInNano(), testRunDurationListener.getEndInNano());
            testResult.addTestItemDurationBean(testItemDurationBean);
            testResult.setOutput(returnObj == null ? "void" : returnObj);
            testResult.setPassed(Boolean.TRUE);
            if (writableRow != null) {
                if (returnObj != null) {
                    this.LOG.debug("Data returned by method {} is {} :", (Object)method.getName(), returnObj);
                    writableRow.put("ActualResult", returnObj);
                    Object expectedResult = writableRow.get("ExpectedResult");
                    if (expectedResult != null) {
                        this.LOG.debug("Expected result exists");
                        if (expectedResult.toString().equals(returnObj.toString())) {
                            writableRow.put("TestStatus", "PASSED");
                        } else {
                            writableRow.put("TestStatus", "FAILED");
                        }
                    }
                }
                this.LOG.debug("testItemDurationBean:" + testItemDurationBean);
                if (testItemDurationBean != null) {
                    Double testDuration = CommonUtils.getRounded(testItemDurationBean.getRoundedMsDifference().doubleValue(), 3);
                    this.LOG.debug("testItemDurationBean.getRoundedMsDifference():" + testDuration);
                    writableRow.put("Duration(ms)", testDuration);
                }
            }
        }
        catch (AssumptionViolatedException e) {
            eachRunNotifier.addFailedAssumption(e);
            this.handleAssumptionViolation(e);
        }
        catch (Throwable e) {
            if (e instanceof AssertionError) {
                testResult.setPassed(Boolean.FALSE);
                testResult.setResult(e.getMessage());
            } else {
                testResult.setException(Boolean.TRUE);
                testResult.setExceptionResult(e.toString());
            }
            eachRunNotifier.addFailure(e);
            throw e;
        }
        finally {
            eachRunNotifier.fireTestFinished();
        }
        if (writableRow != null && writableRow.get("TestStatus") != null && writableRow.get("TestStatus").equals("FAILED")) {
            Assert.fail((String)("Actual Result returned by the method : [" + returnObj + "] did not match the expected result : [" + writableRow.get("ExpectedResult") + "]"));
        }
    }

    protected void handleAssumptionViolation(AssumptionViolatedException e) {
        this.fInvalidParameters.add(e);
    }
}

