/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.runner;

import org.easetech.easytest.annotation.Parallel;
import org.easetech.easytest.internal.SystemProperties;
import org.easetech.easytest.strategy.SchedulerStrategy;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyTestSuite
extends Suite {
    public EasyTestSuite(Class<?> klass) throws InitializationError {
        super(klass, (RunnerBuilder)new AllDefaultPossibilitiesBuilder(true));
        this.setSchedulingStrategy();
        this.setScheduler(SchedulerStrategy.getSchedulerForSuite(klass));
    }

    protected void setSchedulingStrategy() {
        Class testClass = this.getTestClass().getJavaClass();
        super.setScheduler(SchedulerStrategy.getScheduler(testClass, false));
        Parallel parallelAnnotation = testClass.getAnnotation(Parallel.class);
        if (parallelAnnotation != null) {
            int threads = parallelAnnotation.threads();
            System.setProperty(SystemProperties.PARALLEL_THREAD_COUNT.getValue(), String.valueOf(threads));
        }
    }
}

