/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.reports.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import org.easetech.easytest.annotation.Report;
import org.easetech.easytest.reports.data.ReportDataContainer;
import org.easetech.easytest.reports.impl.ReportBuilder;
import org.easetech.easytest.reports.impl.ReportExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportRunner
implements Callable<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(ReportRunner.class);
    private ReportBuilder reportBuilder;
    private ReportExporter reportExporter;
    private ReportDataContainer testReportContainer;
    private Report.EXPORT_FORMAT[] formats;
    private Report.REPORT_TYPE[] types;
    private String destinationLocation;

    public ReportRunner(ReportDataContainer testReportContainer, Report.EXPORT_FORMAT[] formats, Report.REPORT_TYPE[] types, String destinationLocation) {
        this.testReportContainer = testReportContainer;
        this.formats = formats;
        this.types = types;
        this.destinationLocation = destinationLocation;
        this.reportBuilder = new ReportBuilder(testReportContainer);
        this.reportExporter = new ReportExporter();
    }

    @Override
    public Boolean call() throws Exception {
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        Boolean returnValue = true;
        for (Report.REPORT_TYPE type : this.types) {
            JRDataSource reportDataSource;
            if (!returnValue.booleanValue()) {
                return false;
            }
            switch (type) {
                case DEFAULT: {
                    reportDataSource = this.reportBuilder.buildDefaultTestReport(reportParameters);
                    break;
                }
                case METHOD_DURATION: {
                    reportDataSource = this.reportBuilder.buildTestMethodDurationReport(reportParameters);
                    break;
                }
                default: {
                    return false;
                }
            }
            returnValue = this.printReportForType(reportParameters, reportDataSource, type);
        }
        return returnValue;
    }

    private boolean printReportForType(Map<String, Object> reportParameters, JRDataSource reportDataSource, Report.REPORT_TYPE type) {
        String className = this.testReportContainer.getClassName();
        reportParameters.put("TEST_CLASS_NAME", className);
        try {
            this.reportExporter.printReport(reportDataSource, reportParameters, this.destinationLocation, className, this.formats, type);
        }
        catch (JRException e) {
            System.out.println((Object)e);
            e.printStackTrace();
            LOG.error("JRException occurred during generation of report", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            System.out.println(e);
            LOG.error("IOException occurred during generation of report", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            System.out.println(e);
            LOG.error("Exception occurred during generation of report", (Throwable)e);
            return false;
        }
        return true;
    }
}

