/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.reports.data;

import java.util.ArrayList;
import java.util.List;
import org.easetech.easytest.annotation.Report;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportParametersBean {
    protected static final Logger LOG = LoggerFactory.getLogger(ReportParametersBean.class);
    private Report.EXPORT_FORMAT[] outputFormats;
    private Report.REPORT_TYPE[] reportTypes;
    private String outputLocation;
    private List<String> packageNames = null;

    public ReportParametersBean(Report.EXPORT_FORMAT[] outputFormats, Report.REPORT_TYPE[] reportTypes, String outputLocation) {
        LOG.info("Processing reports with annotations outputFormats=" + outputFormats + "reportTypes = " + reportTypes + " outputLocation=" + outputLocation);
        this.outputFormats = outputFormats;
        this.reportTypes = reportTypes;
        this.outputLocation = outputLocation;
    }

    public ReportParametersBean(String reportsFormat, String outputLocation, String packages, String reportTypes) {
        LOG.info("Processing reports with command line parameters reports.generate=true reports.format=" + reportsFormat + "reports.type=" + reportTypes + "reports.location=" + outputLocation + " packages=" + packages);
        this.outputFormats = this.initializeOutputFormats(reportsFormat);
        this.reportTypes = this.initializeReportTypes(reportTypes);
        String string = this.outputLocation = outputLocation != null ? outputLocation : "";
        if (packages != null) {
            String[] packagesArray;
            this.packageNames = new ArrayList<String>();
            for (String packageName : packagesArray = packages.split(",")) {
                this.packageNames.add(packageName.trim());
            }
        }
    }

    private Report.EXPORT_FORMAT[] initializeOutputFormats(String reportsFormat) {
        ArrayList<Report.EXPORT_FORMAT> formatResults = new ArrayList<Report.EXPORT_FORMAT>();
        if (reportsFormat != null) {
            String[] formats;
            for (String format : formats = reportsFormat.split(",")) {
                try {
                    formatResults.add(Report.EXPORT_FORMAT.valueOf(format.toUpperCase().trim()));
                }
                catch (Exception e) {
                    LOG.error("Report format " + format + " not supported", (Throwable)e);
                }
            }
        }
        if (formatResults.isEmpty()) {
            formatResults.add(Report.EXPORT_FORMAT.PDF);
            LOG.info("Outputting to PDF as default format");
        }
        return formatResults.toArray(new Report.EXPORT_FORMAT[formatResults.size()]);
    }

    private Report.REPORT_TYPE[] initializeReportTypes(String reportTypes) {
        ArrayList<Report.REPORT_TYPE> reportTypesResults = new ArrayList<Report.REPORT_TYPE>();
        if (reportTypes != null) {
            String[] types;
            for (String type : types = reportTypes.split(",")) {
                try {
                    reportTypesResults.add(Report.REPORT_TYPE.valueOf(type.toUpperCase().trim()));
                }
                catch (Exception e) {
                    LOG.error("Report format " + type + " not supported", (Throwable)e);
                }
            }
        }
        if (reportTypesResults.isEmpty()) {
            reportTypesResults.add(Report.REPORT_TYPE.DEFAULT);
            LOG.info("Report type set to DEFAULT as default report type");
        }
        return reportTypesResults.toArray(new Report.REPORT_TYPE[reportTypesResults.size()]);
    }

    public Report.EXPORT_FORMAT[] getOutputFormats() {
        return this.outputFormats;
    }

    public Report.REPORT_TYPE[] getReportTypes() {
        return this.reportTypes;
    }

    public String getOutputLocation() {
        return this.outputLocation;
    }

    public List<String> getPackageNames() {
        return this.packageNames;
    }
}

