/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.loader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.easetech.easytest.annotation.DataLoader;
import org.easetech.easytest.internal.SystemProperties;
import org.easetech.easytest.io.EmptyResource;
import org.easetech.easytest.io.Resource;
import org.easetech.easytest.io.ResourceLoaderStrategy;
import org.easetech.easytest.loader.DataConverter;
import org.easetech.easytest.loader.Loader;
import org.easetech.easytest.loader.LoaderFactory;
import org.easetech.easytest.loader.LoaderType;
import org.easetech.easytest.util.DataContext;
import org.easetech.easytest.util.TestInfo;
import org.junit.Assert;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataLoaderUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(DataLoaderUtil.class);
    private static final Pattern RUNTIME_EXPR_PATTERN = Pattern.compile("\\$\\{.*\\}");

    public static TestInfo determineLoader(DataLoader testData, TestClass testClass) {
        TestInfo result = new TestInfo(testClass);
        String[] dataFiles = DataLoaderUtil.determineFilePaths(testData);
        LoaderType loaderType = DataLoaderUtil.determineLoaderType(testData, dataFiles);
        Loader dataLoader = null;
        if (LoaderType.CUSTOM.equals((Object)loaderType) || dataFiles.length == 0) {
            dataLoader = DataLoaderUtil.getCustomLoaderInstance(testData);
        } else if (loaderType != null) {
            dataLoader = LoaderFactory.getLoader(loaderType);
        }
        result.setDataLoader(dataLoader);
        result.setFilePaths(dataFiles);
        result.setWriteData(testData.writeData());
        return result;
    }

    private static String[] determineFilePaths(DataLoader dataLoader) {
        String[] filePaths = dataLoader.filePaths();
        String[] result = new String[filePaths.length];
        result = DataLoaderUtil.handleSystemProperty();
        if (result == null) {
            if (filePaths.length == 0) {
                LOG.info("Neither System Property 'testDataFiles' nor the attribute 'filePaths' is specified.");
            } else {
                result = new String[filePaths.length];
                for (int i = 0; i < filePaths.length; ++i) {
                    result[i] = DataLoaderUtil.isVariablePath(filePaths[i]) != false ? DataLoaderUtil.getTestDataFileExpression(filePaths[i]) : filePaths[i];
                }
            }
        }
        return result;
    }

    private static String getTestDataFileExpression(String pathExpression) {
        String variable = pathExpression.substring(2, pathExpression.lastIndexOf("}"));
        return System.getProperty(variable) == null ? variable : System.getProperty(variable);
    }

    private static String[] handleSystemProperty() {
        String[] result = null;
        String datafiles = System.getProperty(SystemProperties.TEST_DATA_FILES.getValue());
        if (datafiles != null && datafiles.length() > 0) {
            result = datafiles.split(",");
        }
        return result;
    }

    private static Boolean isVariablePath(String path) {
        if (path == null || "".equals(path)) {
            return false;
        }
        Matcher exprMatcher = RUNTIME_EXPR_PATTERN.matcher(path);
        if (exprMatcher.matches()) {
            return true;
        }
        return false;
    }

    private static final LoaderType determineLoaderType(DataLoader testData, String[] dataFiles) {
        LoaderType loaderType = testData.loaderType();
        if (LoaderType.NONE.equals((Object)loaderType)) {
            if (dataFiles == null || dataFiles.length == 0) {
                return LoaderType.CUSTOM;
            }
            return DataLoaderUtil.resolveFileExtension(dataFiles[0]);
        }
        return loaderType;
    }

    private static LoaderType resolveFileExtension(String filePath) {
        if (filePath == null || filePath == "") {
            return LoaderType.CUSTOM;
        }
        if (filePath.endsWith("csv")) {
            return LoaderType.CSV;
        }
        if (filePath.endsWith("xls")) {
            return LoaderType.EXCEL;
        }
        if (filePath.endsWith("xml")) {
            return LoaderType.XML;
        }
        return LoaderType.CUSTOM;
    }

    private static Loader getCustomLoaderInstance(DataLoader testData) {
        Loader dataLoader = null;
        LOG.info("User specified to use custom Loader. Trying to get the custom loader.");
        if (testData.loader() == null) {
            Assert.fail((String)"Specified the LoaderType as CUSTOM but did not specify loader attribute. A loaderType of CUSTOM requires the loader attribute specifying the Custom Loader Class which implements Loader interface.");
        } else {
            try {
                Class<? extends Loader> loaderClass = testData.loader();
                dataLoader = loaderClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occured while trying to instantiate a class of type :" + testData.loader(), e);
            }
        }
        return dataLoader;
    }

    public static void loadData(Class<?> testClass, FrameworkMethod method, TestClass currentTestClass, Map<String, List<Map<String, Object>>> writableData) {
        if (testClass == null && method == null) {
            Assert.fail((String)"The framework should provide either the testClass parameter or the method parameter in order to load the test data.");
        }
        DataLoader testData = null;
        testData = testClass != null ? testClass.getAnnotation(DataLoader.class) : (DataLoader)method.getAnnotation(DataLoader.class);
        if (testData != null) {
            TestInfo testInfo = DataLoaderUtil.determineLoader(testData, currentTestClass);
            Loader dataLoader = testInfo.getDataLoader();
            if (testInfo.getDataLoader() == null) {
                Assert.fail((String)"The framework currently does not support the specified Loader type. You can provide the custom Loader by choosing LoaderType.CUSTOM in TestData annotation and providing your custom loader using DataLoader annotation.");
            } else if (testInfo.getFilePaths() == null || testInfo.getFilePaths().length == 0) {
                Map<String, List<Map<String, Object>>> data = dataLoader.loadData(new EmptyResource());
                DataLoaderUtil.fillWritableData(writableData, data, testData.appendData());
                DataContext.setData(DataConverter.appendClassName(data, currentTestClass.getJavaClass()), testData.appendData());
                DataContext.setConvertedData(DataConverter.convert(data, currentTestClass.getJavaClass()), testData.appendData());
            } else {
                ResourceLoaderStrategy resourceLoader = new ResourceLoaderStrategy(currentTestClass.getJavaClass());
                for (String filePath : testInfo.getFilePaths()) {
                    Resource resource = resourceLoader.getResource(filePath);
                    try {
                        if (resource.exists()) {
                            Map<String, List<Map<String, Object>>> data = dataLoader.loadData(resource);
                            DataLoaderUtil.fillWritableData(writableData, data, testData.appendData());
                            DataContext.setData(DataConverter.appendClassName(data, currentTestClass.getJavaClass()), testData.appendData());
                            DataContext.setConvertedData(DataConverter.convert(data, currentTestClass.getJavaClass()), testData.appendData());
                            continue;
                        }
                        LOG.warn("Resource {} does not exists in the specified path. If it is a classpath resource, use 'classpath:' before the path name, else check the path.", (Object)resource);
                    }
                    catch (Exception e) {
                        LOG.error("Exception occured while trying to load the data for resource {}", (Object)resource, (Object)e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    private static void fillWritableData(Map<String, List<Map<String, Object>>> writableData, Map<String, List<Map<String, Object>>> availableData, boolean appendData) {
        if (!appendData) {
            writableData.putAll(availableData);
        } else {
            for (String key : availableData.keySet()) {
                ArrayList newData = new ArrayList();
                if (writableData.get(key) != null) {
                    newData.addAll(writableData.get(key));
                }
                newData.addAll(availableData.get(key));
                writableData.put(key, newData);
            }
        }
    }

    public static boolean isMethodDataLoaded(String methodName) {
        boolean result = false;
        if (DataContext.getData() == null || DataContext.getData().keySet() == null || DataContext.getData().keySet().isEmpty()) {
            result = false;
        } else {
            Iterator<String> keyIterator = DataContext.getData().keySet().iterator();
            while (keyIterator.hasNext() && !(result = methodName.equals(keyIterator.next()))) {
            }
        }
        return result;
    }
}

