/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.loader;

import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.io.Resource;
import org.easetech.easytest.loader.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVDataLoader
implements Loader {
    protected static final Logger LOG = LoggerFactory.getLogger(CSVDataLoader.class);
    private static final char COMMA_SEPARATOR = ',';

    public CSVDataLoader() {
    }

    public CSVDataLoader(List<InputStream> csvInputStreams) throws IOException {
        Map<String, List<Map<String, Object>>> data = null;
        HashMap<String, List<Map<String, Object>>> finalData = new HashMap<String, List<Map<String, Object>>>();
        for (InputStream stream : csvInputStreams) {
            data = CSVDataLoader.loadFromSpreadsheet(stream);
            finalData.putAll(data);
        }
    }

    @Override
    public Map<String, List<Map<String, Object>>> loadData(Resource resource) {
        Map<String, List<Map<String, Object>>> result = null;
        try {
            result = CSVDataLoader.loadFromSpreadsheet(resource.getInputStream());
        }
        catch (IOException e) {
            LOG.error("IOException occured while trying to Load the resource {} . Moving to the next resource.", (Object)resource.getResourceName(), (Object)e);
        }
        if (result != null) {
            LOG.debug("Loading data from resource {} succedded and the data loaded is {}", (Object)resource.getResourceName(), result);
        }
        return result;
    }

    private static Map<String, List<Map<String, Object>>> loadFromSpreadsheet(InputStream csvFile) throws IOException {
        HashMap<String, List<Map<String, Object>>> data = new HashMap<String, List<Map<String, Object>>>();
        CsvReader csvReader = new CsvReader((Reader)new InputStreamReader(csvFile), ',');
        Boolean isKeyRow = true;
        ArrayList dataValues = null;
        HashMap<Integer, String> tempData = new HashMap<Integer, String>();
        data = new HashMap();
        while (csvReader.readRecord()) {
            int i;
            StringBuffer logBuffer = new StringBuffer("Record being read is :");
            HashMap actualData = new HashMap();
            String[] splitValues = csvReader.getValues();
            isKeyRow = splitValues.length > 0 && "".equals(splitValues[0]) ? Boolean.valueOf(false) : Boolean.valueOf(true);
            if (isKeyRow.booleanValue()) {
                dataValues = new ArrayList();
                for (i = 0; i < splitValues.length; ++i) {
                    tempData.put(i, splitValues[i]);
                    logBuffer.append(":" + splitValues[i]);
                }
                data.put((String)tempData.get(0), dataValues);
            } else {
                for (i = 1; i < splitValues.length; ++i) {
                    actualData.put(tempData.get(i), CSVDataLoader.normalize(splitValues[i]));
                    logBuffer.append(":" + splitValues[i]);
                }
            }
            if (!isKeyRow.booleanValue()) {
                dataValues.add(actualData);
            }
            LOG.debug(logBuffer.toString());
        }
        return data;
    }

    private static String normalize(String value) {
        return value.replaceAll("'", "\"").replaceAll("&", ",");
    }

    @Override
    public void writeData(Resource resource, Map<String, List<Map<String, Object>>> actualData, String ... methodNames) {
        if (methodNames == null || methodNames.length == 0) {
            this.writeFullDataToCSV(resource, actualData);
        } else {
            for (String methodName : methodNames) {
                this.writeDataToCSV(resource, actualData, methodName);
            }
        }
    }

    private void writeFullDataToCSV(Resource resource, Map<String, List<Map<String, Object>>> actualData) {
        ArrayList<String[]> writableData = new ArrayList<String[]>();
        try {
            for (String methodName : actualData.keySet()) {
                boolean isHeaderWritten = false;
                LinkedHashMap<String, Integer> parameterIndexMap = new LinkedHashMap<String, Integer>();
                int noOfColumns = 0;
                for (Map<String, Object> methodData : actualData.get(methodName)) {
                    int columnIndex;
                    LOG.debug("methodData.keySet().size" + methodData.keySet().size());
                    LOG.debug("methodData" + methodData);
                    if (!isHeaderWritten) {
                        columnIndex = 0;
                        noOfColumns = methodData.keySet().size() + 1;
                        String[] headerValues = new String[noOfColumns];
                        headerValues[columnIndex++] = methodName;
                        Iterator<String> i$ = methodData.keySet().iterator();
                        while (i$.hasNext()) {
                            String parameterName;
                            headerValues[columnIndex] = parameterName = i$.next();
                            parameterIndexMap.put(parameterName, columnIndex);
                            ++columnIndex;
                        }
                        parameterIndexMap.put("Duration(ms)", columnIndex++);
                        isHeaderWritten = true;
                        writableData.add(headerValues);
                    }
                    if (!isHeaderWritten) continue;
                    columnIndex = 0;
                    String[] parameterValues = new String[noOfColumns];
                    parameterValues[columnIndex++] = null;
                    for (String parameter : methodData.keySet()) {
                        parameterValues[((Integer)parameterIndexMap.get((Object)parameter)).intValue()] = methodData.get(parameter) != null ? methodData.get(parameter).toString() : null;
                    }
                    parameterValues[((Integer)parameterIndexMap.get((Object)"Duration(ms)")).intValue()] = methodData.get("Duration(ms)").toString();
                    writableData.add(parameterValues);
                }
            }
            CsvWriter csvWriter = new CsvWriter(resource.getOutputStream(), ',', Charset.defaultCharset());
            for (String[] data : writableData) {
                csvWriter.writeRecord(data);
            }
            csvWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private void writeDataToCSV(Resource resource, Map<String, List<Map<String, Object>>> actualData, String ... methodNames) {
        Boolean isKeyRow = true;
        ArrayList<String[]> writableData = new ArrayList<String[]>();
        try {
            CsvReader csvReader = new CsvReader((Reader)new InputStreamReader(resource.getInputStream()), ',');
            String currentMethodName = "";
            int dataRowIndex = 0;
            String[] dataKeys = null;
            while (csvReader.readRecord()) {
                List<Map<String, Object>> currentMethodData;
                String[] splitValues = csvReader.getValues();
                String[] newSplitValues = (String[])Array.newInstance(String[].class.getComponentType(), splitValues.length);
                System.arraycopy(splitValues, 0, newSplitValues, 0, Math.min(splitValues.length, newSplitValues.length));
                if (splitValues.length > 0 && "".equals(splitValues[0])) {
                    isKeyRow = false;
                } else {
                    dataKeys = splitValues;
                    isKeyRow = true;
                    currentMethodName = splitValues[0];
                    if (!this.writeDataForMethod(currentMethodName, methodNames).booleanValue()) {
                        writableData.add(splitValues);
                        continue;
                    }
                }
                if (isKeyRow.booleanValue()) {
                    dataRowIndex = 0;
                    currentMethodData = actualData.get(currentMethodName);
                    int length = splitValues.length;
                    if (currentMethodData != null && !currentMethodData.isEmpty()) {
                        if (currentMethodData.get(0).keySet().contains("TestStatus")) {
                            newSplitValues = (String[])Array.newInstance(String[].class.getComponentType(), length + 3);
                            System.arraycopy(splitValues, 0, newSplitValues, 0, Math.min(splitValues.length, newSplitValues.length));
                            newSplitValues[length] = "ActualResult";
                            newSplitValues[length + 1] = "TestStatus";
                            newSplitValues[length + 2] = "Duration(ms)";
                        } else if (currentMethodData.get(0).keySet().contains("ActualResult")) {
                            newSplitValues = (String[])Array.newInstance(String[].class.getComponentType(), length + 2);
                            System.arraycopy(splitValues, 0, newSplitValues, 0, Math.min(splitValues.length, newSplitValues.length));
                            newSplitValues[length] = "ActualResult";
                            newSplitValues[length + 1] = "Duration(ms)";
                        } else {
                            newSplitValues = (String[])Array.newInstance(String[].class.getComponentType(), length + 1);
                            System.arraycopy(splitValues, 0, newSplitValues, 0, Math.min(splitValues.length, newSplitValues.length));
                            newSplitValues[length] = "Duration(ms)";
                        }
                        dataKeys = newSplitValues;
                    }
                    writableData.add(newSplitValues);
                    if (length != 1 || currentMethodData.isEmpty()) continue;
                    Map<String, Object> currentRowData = currentMethodData.get(dataRowIndex++);
                    String[] finalValues = new String[dataKeys.length];
                    finalValues[0] = " ";
                    this.writeOutputData(currentRowData, finalValues, dataKeys);
                    writableData.add(finalValues);
                    continue;
                }
                if (!this.writeDataForMethod(currentMethodName, methodNames).booleanValue()) {
                    writableData.add(splitValues);
                    continue;
                }
                currentMethodData = actualData.get(currentMethodName);
                Map<String, Object> currentRowData = currentMethodData.get(dataRowIndex++);
                String[] finalValues = new String[dataKeys.length];
                finalValues[0] = " ";
                for (int i = 1; i < dataKeys.length; ++i) {
                    finalValues[i] = currentRowData.get(dataKeys[i]) == null ? "null" : currentRowData.get(dataKeys[i]).toString();
                }
                this.writeOutputData(currentRowData, finalValues, dataKeys);
                writableData.add(finalValues);
            }
            FileWriter fileWriter = new FileWriter(resource.getFile(), false);
            CsvWriter csvWriter = new CsvWriter((Writer)fileWriter, ',');
            for (String[] data : writableData) {
                csvWriter.writeRecord(data);
            }
            csvWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void writeOutputData(Map<String, Object> currentRowData, String[] finalValues, String[] dataKeys) {
        if (currentRowData.get("TestStatus") != null) {
            finalValues[dataKeys.length - 3] = currentRowData.get("ActualResult").toString();
            finalValues[dataKeys.length - 2] = currentRowData.get("TestStatus").toString();
            finalValues[dataKeys.length - 1] = currentRowData.get("Duration(ms)").toString();
        } else if (currentRowData.get("ActualResult") != null) {
            finalValues[dataKeys.length - 2] = currentRowData.get("ActualResult").toString();
            finalValues[dataKeys.length - 1] = currentRowData.get("Duration(ms)").toString();
        } else {
            finalValues[dataKeys.length - 1] = currentRowData.get("Duration(ms)").toString();
        }
    }

    private Boolean writeDataForMethod(String currentMethod, String ... methodNames) {
        if (methodNames == null || methodNames.length == 0) {
            return true;
        }
        for (String methodName : methodNames) {
            if (!methodName.equals(currentMethod)) continue;
            return true;
        }
        return false;
    }
}

