/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.easetech.easytest.io.Resource;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathResource
implements Resource {
    private ClassLoader classLoader;
    private String path;
    private Class<?> classObj;

    public ClasspathResource(String path) {
        if (path == null || path.length() <= 0) {
            Assert.fail((String)"The supplied path must be a non empty and Not Null value");
        }
        this.path = path;
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public ClasspathResource(String path, ClassLoader classLoader) {
        if (path == null || path.length() <= 0) {
            Assert.fail((String)"The supplied path must be a non empty and Not Null value");
        }
        this.path = path;
        this.classLoader = classLoader;
    }

    public ClasspathResource(String path, Class<?> classObj) {
        if (path == null || path.length() <= 0) {
            Assert.fail((String)"The supplied path must be a non empty and Not Null value");
        }
        this.path = path;
        this.classObj = classObj;
    }

    public ClasspathResource(String path, ClassLoader classLoader, Class<?> classObj) {
        if (path == null || path.length() <= 0) {
            Assert.fail((String)"The supplied path must be a non empty and Not Null value");
        }
        this.path = path;
        this.classObj = classObj;
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader != null ? this.classLoader : (this.classObj != null ? this.classObj.getClassLoader() : Thread.currentThread().getContextClassLoader());
    }

    public String getPath() {
        return this.path;
    }

    public Class<?> getClassObj() {
        return this.classObj;
    }

    @Override
    public boolean exists() {
        return this.getClassObj() != null ? (this.getClassObj().getResource(this.getPath()) != null ? true : this.getClassLoader().getResource(this.getPath()) != null) : this.getClassLoader().getResource(this.getPath()) != null;
    }

    @Override
    public InputStream getInputStream() {
        InputStream is = null;
        if (this.getClassObj() != null) {
            is = this.getClassObj().getResourceAsStream(this.getPath());
            if (is == null) {
                is = this.getClassLoader().getResourceAsStream(this.getPath());
            }
        } else {
            is = this.getClassLoader().getResourceAsStream(this.getPath());
        }
        if (is == null) {
            throw new RuntimeException("File : " + this.getPath() + " cannot be opened because it does not exist");
        }
        return is;
    }

    @Override
    public URL getURL() {
        URL url = null;
        if (this.getClassObj() != null) {
            url = this.getClassObj().getResource(this.getPath());
            if (url == null) {
                url = this.getClassLoader().getResource(this.getPath());
            }
        } else {
            url = this.getClassLoader().getResource(this.getPath());
        }
        if (url == null) {
            throw new RuntimeException("File : " + this.getPath() + " cannot be opened because it does not exist");
        }
        return url;
    }

    @Override
    public File getFile() {
        File file = null;
        URL url = this.getURL();
        if (url != null) {
            try {
                file = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                Assert.fail((String)("URISyntaxException occured while trying to get a URI from a given URL : " + url.toString() + " . This mainly occurs if this URL is not formatted strictly according to to RFC2396 and thus cannot be converted to a URI. Exception message is : " + e.getMessage()));
            }
        }
        return file;
    }

    @Override
    public String getResourceName() {
        if (this.getURL() != null) {
            return this.getURL().getPath();
        }
        return this.getPath();
    }

    @Override
    public OutputStream getOutputStream() {
        FileOutputStream outputStream = null;
        if (this.getFile() != null) {
            try {
                outputStream = new FileOutputStream(this.getFile());
            }
            catch (FileNotFoundException e) {
                try {
                    outputStream = new FileOutputStream(this.getResourceName());
                }
                catch (FileNotFoundException e1) {
                    throw new RuntimeException(this.getResourceName() + " cannot be opened because it does not exist");
                }
            }
        }
        return outputStream;
    }

    public String toString() {
        return "ClasspathResource [path=" + this.path + "]";
    }
}

