/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.easetech.easytest.annotation.Format;
import org.easetech.easytest.annotation.Param;
import org.easetech.easytest.annotation.TestPolicy;
import org.easetech.easytest.internal.DateTimeFormat;
import org.easetech.easytest.internal.EasyParamSignature;
import org.easetech.easytest.loader.DataConverter;
import org.easetech.easytest.runner.EasyFrameworkMethod;
import org.junit.experimental.theories.PotentialAssignment;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyAssignments {
    private final List<PotentialAssignment> fAssigned;
    private final List<EasyParamSignature> fUnassigned;
    private final TestClass fClass;

    public EasyAssignments(List<PotentialAssignment> assigned, List<EasyParamSignature> unassigned, TestClass testClass) {
        this.fUnassigned = unassigned;
        this.fAssigned = assigned;
        this.fClass = testClass;
    }

    public static EasyAssignments allUnassigned(Method testMethod, TestClass testClass) throws Exception {
        List<EasyParamSignature> signatures = EasyParamSignature.signatures(testClass.getOnlyConstructor());
        signatures.addAll(EasyParamSignature.signatures(testMethod));
        return new EasyAssignments(new ArrayList<PotentialAssignment>(), signatures, testClass);
    }

    public boolean isComplete() {
        return this.fUnassigned.size() == 0;
    }

    public EasyParamSignature nextUnassigned() {
        return this.fUnassigned.get(0);
    }

    public EasyAssignments assignNext(PotentialAssignment source) {
        ArrayList<PotentialAssignment> assigned = new ArrayList<PotentialAssignment>(this.fAssigned);
        assigned.add(source);
        return new EasyAssignments(assigned, this.fUnassigned.subList(1, this.fUnassigned.size()), this.fClass);
    }

    public Object[] getActualValues(int start, int stop, boolean nullsOk) throws PotentialAssignment.CouldNotGenerateValueException {
        Object[] values = new Object[stop - start];
        for (int i = start; i < stop; ++i) {
            Object value = this.fAssigned.get(i).getValue();
            if (value == null && !nullsOk) {
                throw new PotentialAssignment.CouldNotGenerateValueException();
            }
            values[i - start] = value;
        }
        return values;
    }

    public List<PotentialAssignment> potentialsForNextUnassigned(EasyFrameworkMethod testMethod) throws InstantiationException, IllegalAccessException {
        String testMethodName = DataConverter.getFullyQualifiedTestName(testMethod.getMethodNameForTestData(), this.fClass.getJavaClass());
        EasyParamSignature unassigned = this.nextUnassigned();
        return this.getSupplier(testMethod).getValueSources(testMethod, testMethodName, unassigned);
    }

    public Param.DataSupplier getSupplier(EasyFrameworkMethod testMethod) throws InstantiationException, IllegalAccessException {
        Param.DataSupplier supplier = new Param.DataSupplier();
        DateTimeFormat dateTimeFormat = new DateTimeFormat();
        if (this.getDateFormat(testMethod) != null) {
            dateTimeFormat.setDateFormat(this.getDateFormat(testMethod));
        }
        if (this.getDateTimeFormat(testMethod) != null) {
            dateTimeFormat.setDateTimeFormat(this.getDateTimeFormat(testMethod));
        }
        if (this.getTimeFormat(testMethod) != null) {
            dateTimeFormat.setTimeFormat(this.getTimeFormat(testMethod));
        }
        supplier.setDateTimeFormatToUse(dateTimeFormat);
        return supplier;
    }

    public Object[] getConstructorArguments(boolean nullsOk) throws PotentialAssignment.CouldNotGenerateValueException {
        return this.getActualValues(0, this.getConstructorParameterCount(), nullsOk);
    }

    public Object[] getMethodArguments(boolean nullsOk) throws PotentialAssignment.CouldNotGenerateValueException {
        return this.getActualValues(this.getConstructorParameterCount(), this.fAssigned.size(), nullsOk);
    }

    public Object[] getAllArguments(boolean nullsOk) throws PotentialAssignment.CouldNotGenerateValueException {
        return this.getActualValues(0, this.fAssigned.size(), nullsOk);
    }

    private int getConstructorParameterCount() {
        List<EasyParamSignature> signatures = EasyParamSignature.signatures(this.fClass.getOnlyConstructor());
        int constructorParameterCount = signatures.size();
        return constructorParameterCount;
    }

    public Object[] getArgumentStrings(boolean nullsOk) throws PotentialAssignment.CouldNotGenerateValueException {
        Object[] values = new Object[this.fAssigned.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.fAssigned.get(i).getDescription();
        }
        return values;
    }

    protected String[] getDateFormat(EasyFrameworkMethod testMethod) {
        String[] dateFormat = null;
        Format formatToUse = this.formatToUse(testMethod);
        if (formatToUse != null) {
            dateFormat = formatToUse.date();
        }
        return dateFormat;
    }

    protected String[] getTimeFormat(EasyFrameworkMethod testMethod) {
        String[] timeFormat = null;
        Format formatToUse = this.formatToUse(testMethod);
        if (formatToUse != null) {
            timeFormat = formatToUse.date();
        }
        return timeFormat;
    }

    protected String[] getDateTimeFormat(EasyFrameworkMethod testMethod) {
        String[] dateTimeFormat = null;
        Format formatToUse = this.formatToUse(testMethod);
        if (formatToUse != null) {
            dateTimeFormat = formatToUse.dateTime();
        }
        return dateTimeFormat;
    }

    private Format formatToUse(EasyFrameworkMethod testMethod) {
        Format policyLevelFormat = null;
        TestPolicy testPolicy = this.fClass.getJavaClass().getAnnotation(TestPolicy.class);
        if (testPolicy != null) {
            policyLevelFormat = testPolicy.value().getAnnotation(Format.class);
        }
        Format classLevelFormat = this.fClass.getJavaClass().getAnnotation(Format.class);
        Format methodLevelFormat = (Format)testMethod.getAnnotation(Format.class);
        Format formatToUse = methodLevelFormat != null ? methodLevelFormat : (classLevelFormat != null ? classLevelFormat : policyLevelFormat);
        return formatToUse;
    }
}

