/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.converter.BaseConverter;
import org.easetech.easytest.converter.Converter;
import org.easetech.easytest.converter.ConverterManager;
import org.easetech.easytest.converter.ParamAwareConverter;
import org.easetech.easytest.internal.EasyParamSignature;
import org.junit.experimental.theories.PotentialAssignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDefinedCollectionConverter
implements BaseConverter<List<Map<String, Object>>, List<PotentialAssignment>> {
    private final Collection collection;
    private final EasyParamSignature signature;
    private final String paramName;
    private static final Logger LOG = LoggerFactory.getLogger(UserDefinedCollectionConverter.class);

    public UserDefinedCollectionConverter(EasyParamSignature signature, String paramName, Collection collection) {
        this.signature = signature;
        this.paramName = paramName;
        this.collection = collection;
    }

    @Override
    public List<PotentialAssignment> convert(List<Map<String, Object>> convertFrom) {
        ArrayList<PotentialAssignment> potentialAssignments = null;
        Class<Object> genericType = this.signature.getIsGenericParameter() != false ? this.signature.getGenericParameterArgType() : Object.class;
        LOG.debug("Editor for class {}  not found. Trying to find converter.", genericType);
        Converter<?> converter = ConverterManager.findConverter(genericType);
        if (converter != null) {
            potentialAssignments = new ArrayList<PotentialAssignment>();
            LOG.debug("Converter for class {} found ", genericType);
            for (Map<String, Object> object : convertFrom) {
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                String values = (String)object.get(this.paramName);
                String[] splitValues = values.split(":");
                for (int i = 0; i < splitValues.length; ++i) {
                    tempMap.put(this.paramName, splitValues[i]);
                    Object value = null;
                    value = converter instanceof ParamAwareConverter ? (Object)((ParamAwareConverter)converter).convert(tempMap, this.paramName) : (Object)converter.convert((Map<String, Object>)tempMap);
                    this.collection.add(value);
                }
                potentialAssignments.add(PotentialAssignment.forValue((String)"", (Object)this.collection));
            }
        }
        return potentialAssignments;
    }
}

