/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.converter;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.converter.BaseConverter;
import org.easetech.easytest.util.GeneralUtil;
import org.junit.experimental.theories.PotentialAssignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyEditorConverter
implements BaseConverter<List<Map<String, Object>>, List<PotentialAssignment>> {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyEditorConverter.class);
    private final Class<?> parameterType;
    private final String paramName;

    public PropertyEditorConverter(Class<?> parameterType, String paramName) {
        this.parameterType = parameterType;
        this.paramName = paramName;
    }

    @Override
    public List<PotentialAssignment> convert(List<Map<String, Object>> convertFrom) {
        LOG.debug("Trying to convert the data using any registered Property Editors. The class responsible for conversion is {}", (Object)PropertyEditorConverter.class.getSimpleName());
        ArrayList<PotentialAssignment> potentialAssignments = null;
        PropertyEditor editor = PropertyEditorManager.findEditor(this.parameterType);
        if (editor != null) {
            potentialAssignments = new ArrayList<PotentialAssignment>();
            LOG.debug("Editor for class {} found", this.parameterType);
            for (Map<String, Object> object : convertFrom) {
                if (this.paramName != null && !"".equals(this.paramName)) {
                    if (GeneralUtil.getStringValue(this.paramName, object) != null) {
                        editor.setAsText(GeneralUtil.getStringValue(this.paramName, object));
                    }
                } else if (GeneralUtil.getStringValue(this.parameterType.getSimpleName(), object) != null) {
                    editor.setAsText(GeneralUtil.getStringValue(this.parameterType.getSimpleName(), object));
                }
                potentialAssignments.add(PotentialAssignment.forValue((String)"", (Object)editor.getValue()));
            }
        }
        return potentialAssignments;
    }
}

