/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.converter.BaseConverter;
import org.easetech.easytest.converter.JSONDataConverter;
import org.easetech.easytest.internal.DateTimeFormat;
import org.easetech.easytest.util.GeneralUtil;
import org.junit.experimental.theories.PotentialAssignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamConstructorConverter
implements BaseConverter<List<Map<String, Object>>, List<PotentialAssignment>> {
    private final Class<?> parameterType;
    private final String paramName;
    private final Collection collection;
    private final Boolean convertEmptyToNull;
    private final DateTimeFormat dateTimeFormat;
    private static final Logger LOG = LoggerFactory.getLogger(JSONDataConverter.class);

    public ParamConstructorConverter(Class<?> parameterType, String paramName, Collection collection, Boolean convertEmptyToNull, DateTimeFormat dateTimeFormat) {
        this.parameterType = parameterType;
        this.paramName = paramName;
        this.collection = collection;
        this.convertEmptyToNull = convertEmptyToNull;
        this.dateTimeFormat = dateTimeFormat;
    }

    @Override
    public List<PotentialAssignment> convert(List<Map<String, Object>> convertFrom) {
        LOG.debug("Trying to call the constructor, if any of the class {} to populate the data", this.parameterType);
        ArrayList<PotentialAssignment> potentialAssignments = new ArrayList<PotentialAssignment>();
        Boolean populated = false;
        try {
            populated = GeneralUtil.fillDataUsingConstructor(this.parameterType, convertFrom, potentialAssignments, this.paramName, this.collection, this.convertEmptyToNull, this.dateTimeFormat);
        }
        catch (Exception e) {
            LOG.debug("Exception occured while trying to populate the data by instantiating the parameter object", (Throwable)e);
            potentialAssignments = null;
        }
        if (!populated.booleanValue()) {
            potentialAssignments = null;
        }
        return potentialAssignments;
    }
}

