/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.converter.BaseConverter;
import org.easetech.easytest.util.GeneralUtil;
import org.junit.experimental.theories.PotentialAssignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataAlreadyConvertedConverter
implements BaseConverter<List<Map<String, Object>>, List<PotentialAssignment>> {
    private static final Logger LOG = LoggerFactory.getLogger(DataAlreadyConvertedConverter.class);
    private final Class<?> parameterType;
    private final String paramName;
    private final Boolean convertEmptyToNull;

    public DataAlreadyConvertedConverter(Class<?> parameterType, String paramName, Boolean convertEmptyToNull) {
        this.parameterType = parameterType;
        this.paramName = paramName;
        this.convertEmptyToNull = convertEmptyToNull;
    }

    @Override
    public List<PotentialAssignment> convert(List<Map<String, Object>> convertFrom) {
        LOG.debug("Trying to verify whether the data has already been converted by the user or not");
        ArrayList<PotentialAssignment> potentialAssignments = null;
        if (GeneralUtil.dataAlreadyConverted(this.parameterType, convertFrom, this.paramName).booleanValue()) {
            LOG.debug("Data is converted by the user. Filling it up");
            potentialAssignments = new ArrayList<PotentialAssignment>();
            Object value = null;
            for (Map<String, Object> object : convertFrom) {
                if (String.class.isAssignableFrom(this.parameterType)) {
                    if (this.convertEmptyToNull.booleanValue()) {
                        if (object.get(this.paramName) != null && "".equals(object.get(this.paramName).toString())) {
                            potentialAssignments.add(PotentialAssignment.forValue((String)"", value));
                            continue;
                        }
                        potentialAssignments.add(PotentialAssignment.forValue((String)"", (Object)object.get(this.paramName)));
                        continue;
                    }
                    potentialAssignments.add(PotentialAssignment.forValue((String)"", (Object)object.get(this.paramName)));
                    continue;
                }
                potentialAssignments.add(PotentialAssignment.forValue((String)"", (Object)object.get(this.paramName)));
            }
        }
        return potentialAssignments;
    }
}

