/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.converter;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.converter.BaseConverter;
import org.easetech.easytest.converter.CollectionConverter;
import org.easetech.easytest.converter.DataAlreadyConvertedConverter;
import org.easetech.easytest.converter.JSONDataConverter;
import org.easetech.easytest.converter.MapConverter;
import org.easetech.easytest.converter.ParamConstructorConverter;
import org.easetech.easytest.converter.PropertyEditorConverter;
import org.easetech.easytest.converter.StandardObjectConverter;
import org.easetech.easytest.converter.UserDefinedConverter;
import org.easetech.easytest.internal.DateTimeFormat;
import org.easetech.easytest.internal.EasyParamSignature;
import org.junit.experimental.theories.PotentialAssignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionDelegator
implements BaseConverter<List<Map<String, Object>>, List<PotentialAssignment>> {
    private final EasyParamSignature signature;
    private final String paramName;
    private final Map<String, BaseConverter<List<Map<String, Object>>, List<PotentialAssignment>>> converters = new LinkedHashMap<String, BaseConverter<List<Map<String, Object>>, List<PotentialAssignment>>>();
    private static final String DATA_ALREADY_CONVERTED_CONVERTER = "dataAlreadyConvertedConverter";
    private static final String MAP_OBJECT_CONVERTER = "mapObjectConverter";
    private static final String STANDARD_OBJECT_CONVERTER = "standardObjectConverter";
    private static final String PROPERTY_EDITOR_CONVERTER = "propertyEditorConverter";
    private static final String USER_DEFINED_CONVERTER = "userDefinedConverter";
    private static final String JSON_DATA_CONVERTER = "jsonDataConverter";
    private static final String PARAM_CONSTRUCTOR_CONVERTER = "paramConstructorConverter";
    private static final String COLLECTIONS_CONVERTER = "collectionsConverter";

    public ConversionDelegator(EasyParamSignature signature, String paramName, Boolean convertEmptyToNull, DateTimeFormat dateTimeFormat) {
        this.signature = signature;
        this.paramName = paramName == null ? signature.getParameterType().getSimpleName() : paramName;
        this.converters.put(DATA_ALREADY_CONVERTED_CONVERTER, new DataAlreadyConvertedConverter(signature.getParameterType(), this.paramName, convertEmptyToNull));
        this.converters.put(MAP_OBJECT_CONVERTER, new MapConverter(signature.getParameterType()));
        this.converters.put(COLLECTIONS_CONVERTER, new CollectionConverter(signature, this.paramName, convertEmptyToNull, dateTimeFormat));
        this.converters.put(STANDARD_OBJECT_CONVERTER, new StandardObjectConverter(signature.getParameterType(), this.paramName, convertEmptyToNull, dateTimeFormat));
        this.converters.put(PROPERTY_EDITOR_CONVERTER, new PropertyEditorConverter(signature.getParameterType(), this.paramName));
        this.converters.put(USER_DEFINED_CONVERTER, new UserDefinedConverter(signature.getParameterType(), this.paramName, convertEmptyToNull, dateTimeFormat));
        this.converters.put(JSON_DATA_CONVERTER, new JSONDataConverter(signature.getParameterType(), this.paramName));
        this.converters.put(PARAM_CONSTRUCTOR_CONVERTER, new ParamConstructorConverter(signature.getParameterType(), this.paramName, null, convertEmptyToNull, dateTimeFormat));
    }

    public ConversionDelegator(EasyParamSignature signature, String paramName, LinkedHashMap<String, BaseConverter<List<Map<String, Object>>, List<PotentialAssignment>>> converters) {
        this.signature = signature;
        this.paramName = paramName == null ? signature.getParameterType().getSimpleName() : paramName;
        this.converters.putAll(converters);
    }

    @Override
    public List<PotentialAssignment> convert(List<Map<String, Object>> convertFrom) {
        String key;
        List<PotentialAssignment> potentialAssignments = null;
        Iterator<String> i$ = this.converters.keySet().iterator();
        while (i$.hasNext() && (potentialAssignments = this.converters.get(key = i$.next()).convert(convertFrom)) == null) {
        }
        return potentialAssignments;
    }
}

