/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.easetech.easytest.converter.ConversionDelegator;
import org.easetech.easytest.internal.DateTimeFormat;
import org.easetech.easytest.internal.EasyParamSignature;
import org.easetech.easytest.runner.EasyFrameworkMethod;
import org.easetech.easytest.util.ConfigContext;
import org.easetech.easytest.util.DataContext;
import org.junit.Assert;
import org.junit.experimental.theories.PotentialAssignment;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface Param {
    public String name();

    public boolean convertEmptyToNull() default false;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataSupplier {
        private DateTimeFormat dateTimeFormatToUse;

        public List<PotentialAssignment> getValueSources(EasyFrameworkMethod method, String testMethodName, EasyParamSignature signature) {
            Param provider = signature.getAnnotation(Param.class);
            if (testMethodName == null) {
                Assert.fail((String)"The framework could not locate the test data for the test method. If you are using TestData annotation, make sure you specify the test method name in the data file. In case you are using ParametersSuppliedBy annotation, make sure you are using the right ParameterSupplier subclass.");
            }
            List<Object> listOfData = null;
            Map<String, List<Map<String, Object>>> data = DataContext.getConvertedData();
            List<Map<String, Object>> methodData = data.get(testMethodName);
            List<PotentialAssignment> listOfDataWithInject = null;
            if (methodData == null && this.injectData(method)) {
                listOfDataWithInject = this.handleMethodInjection(method, signature);
                if (listOfDataWithInject != null) {
                    listOfData = new ArrayList<PotentialAssignment>();
                    listOfData.addAll(listOfDataWithInject);
                } else {
                    Assert.fail((String)("Data does not exist for the specified method with name :" + testMethodName + " .Please check that the Data file contains the data for the given method name. A possible cause could be spelling mismatch."));
                }
            } else {
                Boolean convertEmptyToNull;
                List<Map<String, Object>> testData = data.get(testMethodName);
                String paramName = provider != null ? provider.name() : null;
                listOfData = new ConversionDelegator(signature, paramName, convertEmptyToNull = Boolean.valueOf(provider != null ? provider.convertEmptyToNull() : false), this.dateTimeFormatToUse).convert(testData);
                if (listOfData == null && (listOfDataWithInject = this.handleMethodInjection(method, signature)) != null) {
                    listOfData = new ArrayList();
                    listOfData.addAll(listOfDataWithInject);
                }
                if (listOfData == null) {
                    Assert.fail((String)("Unable to find any test data conversion strategy for parameter with name " + paramName + "and type " + signature.getParameterType()));
                }
            }
            return listOfData;
        }

        public boolean injectData(EasyFrameworkMethod method) {
            return method.getAnnotation(Inject.class) != null;
        }

        public void setDateTimeFormatToUse(DateTimeFormat dateTimeFormatToUse) {
            this.dateTimeFormatToUse = dateTimeFormatToUse;
        }

        public List<PotentialAssignment> handleMethodInjection(EasyFrameworkMethod method, EasyParamSignature signature) {
            Inject injectAnnotation = (Inject)method.getAnnotation(Inject.class);
            ArrayList<PotentialAssignment> result = null;
            if (injectAnnotation != null) {
                Named namedInjection = signature.getAnnotation(Named.class);
                String providerBeanName = null;
                Object beanInstance = null;
                if (namedInjection != null) {
                    providerBeanName = namedInjection.value();
                    beanInstance = ConfigContext.getBeanByName(providerBeanName);
                } else {
                    Class<?> parameterType = signature.getParameterType();
                    beanInstance = ConfigContext.getBeanByType(parameterType);
                }
                if (beanInstance == null) {
                    Assert.fail((String)("A test bean with name " + providerBeanName + " does not exist."));
                } else {
                    result = new ArrayList<PotentialAssignment>();
                    result.add(PotentialAssignment.forValue((String)"", (Object)beanInstance));
                }
            }
            return result;
        }
    }
}

