/*
 * Decompiled with CFR 0.152.
 */
package org.dynamicloud.lonline.report;

import java.util.Date;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.dynamicloud.api.DynamicProviderImpl;
import org.dynamicloud.api.Query;
import org.dynamicloud.api.RecordCredential;
import org.dynamicloud.api.RecordResults;
import org.dynamicloud.api.criteria.Condition;
import org.dynamicloud.api.criteria.Conditions;
import org.dynamicloud.api.model.RecordModel;
import org.dynamicloud.lonline.LonlineLog;
import org.dynamicloud.lonline.LonlineSetting;
import org.dynamicloud.lonline.report.LonlineLevel;
import org.dynamicloud.lonline.report.LonlineReportCallback;
import org.dynamicloud.util.LonlineUtil;

public class LonlineReport {
    public static void fetch(LonlineLevel level, Date from, Date to, LonlineReportCallback callback) {
        LonlineReport.fetch(level, from, to, null, callback);
    }

    public static void fetch(LonlineLevel level, Date from, Date to, Class clazz, LonlineReportCallback callback) {
        Enumeration allAppenders = Logger.getRootLogger().getAllAppenders();
        while (allAppenders.hasMoreElements()) {
            Appender appender = (Appender)allAppenders.nextElement();
            if (!(appender instanceof LonlineSetting)) continue;
            LonlineSetting settings = (LonlineSetting)appender;
            RecordCredential credentials = new RecordCredential(settings.getCsk(), settings.getAci());
            DynamicProviderImpl provider = new DynamicProviderImpl(credentials);
            RecordModel recordModel = new RecordModel(Long.valueOf(settings.getModelIdentifier()));
            if (clazz != null && !LonlineLog.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("The passed class must implement LonlineLog interface.");
            }
            recordModel.setBoundClass(clazz == null ? LonlineLog.class : clazz);
            Query query = provider.createQuery(recordModel);
            try {
                if (from != null && to == null) {
                    LonlineUtil.warnIt(settings, "LonlineReport found 'Date to' as null, LonlineReport will use today's date.");
                    to = new Date();
                }
                RecordResults results = from == null ? query.add(Conditions.equals((String)"lonlinelevel", (String)level.getLevel())).orderBy("id").desc().list() : query.add(Conditions.and((Condition)Conditions.equals((String)"lonlinelevel", (String)level.getLevel()), (Condition)Conditions.between((String)"added_at", (Object)from, (Object)to))).orderBy("id").desc().list();
                LonlineReport.handleResults(settings, (Query<LonlineLog>)query, callback, (RecordResults<LonlineLog>)results, results.getFastReturnedSize());
            }
            catch (Exception e) {
                LonlineUtil.warnIt(settings, e.getMessage());
            }
            return;
        }
        throw new IllegalStateException("According to your log4j configuration, the LonlineAppender is not assigned to rootLogger.");
    }

    public static long count(LonlineLevel level, Date from, Date to) {
        Enumeration allAppenders = Logger.getRootLogger().getAllAppenders();
        while (allAppenders.hasMoreElements()) {
            Appender appender = (Appender)allAppenders.nextElement();
            if (!(appender instanceof LonlineSetting)) continue;
            LonlineSetting settings = (LonlineSetting)appender;
            RecordCredential credentials = new RecordCredential(settings.getCsk(), settings.getAci());
            DynamicProviderImpl provider = new DynamicProviderImpl(credentials);
            RecordModel recordModel = new RecordModel(Long.valueOf(settings.getModelIdentifier()));
            recordModel.setBoundClass(LonlineLog.class);
            Query query = provider.createQuery(recordModel);
            query.setProjection("count(*) count");
            try {
                RecordResults results;
                if (from != null && to == null) {
                    LonlineUtil.warnIt(settings, "LonlineReport found 'Date to' as null, LonlineReport will use today's date.");
                    to = new Date();
                }
                if ((results = from == null ? query.add(Conditions.equals((String)"lonlinelevel", (String)level.getLevel())).orderBy("id").desc().list() : query.add(Conditions.and((Condition)Conditions.equals((String)"lonlinelevel", (String)level.getLevel()), (Condition)Conditions.between((String)"added_at", (Object)from, (Object)to))).orderBy("id").desc().list()).getFastReturnedSize() > 0) {
                    return ((LonlineLog)results.getRecords().get(0)).getCount();
                }
                return 0L;
            }
            catch (Exception e) {
                LonlineUtil.warnIt(settings, e.getMessage());
                break;
            }
        }
        throw new IllegalStateException("According to your log4j configuration, the LonlineAppender is not assigned to rootLogger.");
    }

    private static void handleResults(LonlineSetting settings, Query<LonlineLog> query, LonlineReportCallback callback, RecordResults<LonlineLog> results, int howMuchSoFar) {
        for (LonlineLog log : results.getRecords()) {
            callback.manageLog(log);
        }
        try {
            results = query.next();
            if (results.getFastReturnedSize() > 0) {
                LonlineReport.handleResults(settings, query, callback, (RecordResults<LonlineLog>)results, howMuchSoFar + results.getFastReturnedSize());
            }
        }
        catch (Exception e) {
            LonlineUtil.warnIt(settings, e.getMessage());
        }
    }
}

