/*
 * Decompiled with CFR 0.152.
 */
package org.dynamicloud.lonline.processor;

import org.dynamicloud.api.DynamicProviderImpl;
import org.dynamicloud.api.RecordCredential;
import org.dynamicloud.api.model.RecordModel;
import org.dynamicloud.concurrency.ThreadPool;
import org.dynamicloud.exception.DynamicloudProviderException;
import org.dynamicloud.lonline.LonlineLog;
import org.dynamicloud.lonline.LonlineSetting;
import org.dynamicloud.lonline.processor.LonlineProcessor;
import org.dynamicloud.util.LonlineUtil;

public class LonlineProcessorImpl
implements LonlineProcessor {
    private final LonlineSetting settings;

    public LonlineProcessorImpl(LonlineSetting settings) {
        this.settings = settings;
    }

    @Override
    public void process(final LonlineLog log) {
        if (this.settings.isAsync()) {
            ThreadPool.getThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    LonlineProcessorImpl.this.executeService(log);
                }
            });
        } else {
            LonlineUtil.warnIt(this.settings, "async property is false, this is a negative impact to your system's throughput.");
            this.executeService(log);
        }
    }

    private void executeService(LonlineLog log) {
        RecordCredential credentials = new RecordCredential(this.settings.getCsk(), this.settings.getAci());
        DynamicProviderImpl provider = new DynamicProviderImpl(credentials);
        try {
            provider.saveRecord(new RecordModel(Long.valueOf(this.settings.getModelIdentifier())), (Object)log);
        }
        catch (DynamicloudProviderException e) {
            LonlineUtil.warnIt(this.settings, e.getMessage());
        }
    }
}

