/*
 * Decompiled with CFR 0.152.
 */
package org.dynamicloud.concurrency;

import org.dynamicloud.concurrency.BlockingQueue;

public class ThreadPool {
    private static ThreadPool pool;
    private BlockingQueue queue = new BlockingQueue();
    private boolean closed = true;
    private int poolSize = Runtime.getRuntime().availableProcessors() + 2;

    public static ThreadPool getThreadPool() {
        if (pool == null) {
            pool = new ThreadPool();
            pool.start();
        }
        return pool;
    }

    private synchronized void start() {
        if (!this.closed) {
            throw new IllegalStateException("Pool already started.");
        }
        this.closed = false;
        for (int i = 0; i < this.poolSize; ++i) {
            new PooledThread().start();
        }
    }

    public synchronized void execute(Runnable job) {
        if (this.closed) {
            throw new PoolClosedException();
        }
        this.queue.enqueue(job);
    }

    private static class PoolClosedException
    extends RuntimeException {
        PoolClosedException() {
            super("Pool closed.");
        }
    }

    private class PooledThread
    extends Thread {
        private PooledThread() {
        }

        @Override
        public void run() {
            Runnable job;
            while ((job = (Runnable)ThreadPool.this.queue.dequeue()) != null) {
                try {
                    job.run();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

