/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.spaces.controller;

import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManager;
import org.duracloud.client.StoreCaller;
import org.duracloud.common.model.AclType;
import org.duracloud.common.util.ExtendedCountListener;
import org.duracloud.common.util.ExtendedIteratorCounterThread;
import org.duracloud.duradmin.domain.Space;
import org.duracloud.duradmin.domain.SpaceProperties;
import org.duracloud.duradmin.spaces.controller.ItemCounter;
import org.duracloud.duradmin.util.SpaceUtil;
import org.duracloud.error.ContentStoreException;
import org.duracloud.mill.db.repo.JpaBitIntegrityReportRepo;
import org.duracloud.reportdata.bitintegrity.BitIntegrityReportProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/spaces/space"})
public class SpaceController {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ContentStoreManager contentStoreManager;
    private JpaBitIntegrityReportRepo reportRepo;
    private String adminSpaceId;

    @Autowired
    public SpaceController(@Qualifier(value="adminSpaceId") String adminSpaceId, @Qualifier(value="bitIntegrityReportRepo") JpaBitIntegrityReportRepo reportRepo, @Qualifier(value="contentStoreManager") ContentStoreManager contentStoreManager) {
        this.adminSpaceId = adminSpaceId;
        this.reportRepo = reportRepo;
        this.contentStoreManager = contentStoreManager;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public ModelAndView get(HttpServletRequest request, HttpServletResponse response, @Valid Space space, BindingResult result) throws Exception {
        try {
            String prefix = request.getParameter("prefix");
            if (prefix != null) {
                prefix = "".equals(prefix.trim()) ? null : prefix;
            }
            String marker = request.getParameter("marker");
            ContentStore contentStore = this.contentStoreManager.getContentStore(space.getStoreId());
            org.duracloud.domain.Space cloudSpace = contentStore.getSpace(space.getSpaceId(), prefix, 200L, marker);
            ContentStore contentStoreWithoutRetries = this.contentStoreManager.getContentStore(space.getStoreId(), 0);
            this.populateSpace(space, cloudSpace, contentStoreWithoutRetries);
            this.populateSpaceCount(space, request);
            if (space.isMillDbEnabled()) {
                this.populateBitIntegrityResults(space, contentStore);
            }
            return this.createModel(space);
        }
        catch (ContentStoreException ex) {
            ex.printStackTrace();
            response.setStatus(404);
            return this.createModel(null);
        }
    }

    private void populateBitIntegrityResults(Space space, ContentStore contentStore) {
        try {
            BitIntegrityReportProperties bitReportProps = contentStore.getBitIntegrityReportProperties(space.getSpaceId());
            if (bitReportProps == null) {
                this.log.warn("No bit report properties found for space {}", (Object)space.getSpaceId());
            } else {
                space.setBitIntegrityReportProperties(bitReportProps);
            }
        }
        catch (Exception ex) {
            this.log.error("failed to populate bit integrity results due to error:" + ex.getMessage(), (Throwable)ex);
        }
    }

    private void populateSpace(Space space, org.duracloud.domain.Space cloudSpace, ContentStore contentStore) throws ContentStoreException {
        SpaceUtil.populateSpace(space, cloudSpace, contentStore, this.getAuthentication());
        String primaryStoreId = this.contentStoreManager.getPrimaryContentStore().getStoreId();
        boolean primary = primaryStoreId.equals(space.getStoreId());
        space.setPrimaryStorageProvider(primary);
    }

    private void populateSpaceCount(Space space, HttpServletRequest request) throws Exception {
        String countStr;
        if (request.getParameterMap().containsKey("recount")) {
            this.expireItemCount(request, space);
        }
        if ((countStr = space.getProperties().getCount()).endsWith("+")) {
            this.setItemCount(space, request);
        } else {
            space.setItemCount(Long.valueOf(space.getProperties().getCount()));
        }
    }

    private void setItemCount(final Space space, HttpServletRequest request) throws ContentStoreException {
        String key = this.formatItemCountCacheKey(space);
        ServletContext appContext = request.getSession().getServletContext();
        ItemCounter listener = (ItemCounter)appContext.getAttribute(key);
        space.setItemCount(new Long(-1L));
        if (listener != null) {
            if (listener.isCountComplete()) {
                space.setItemCount(listener.getCount());
            } else {
                SpaceProperties properties = space.getProperties();
                Long interCount = listener.getIntermediaryCount();
                if (interCount == null) {
                    interCount = 0L;
                }
                properties.setCount(String.valueOf(interCount) + "+");
                space.setProperties(properties);
            }
        } else {
            ItemCounter itemCounterListener = new ItemCounter();
            appContext.setAttribute(key, (Object)itemCounterListener);
            final ContentStore contentStore = this.contentStoreManager.getContentStore(space.getStoreId());
            StoreCaller<Iterator<String>> caller = new StoreCaller<Iterator<String>>(){

                protected Iterator<String> doCall() throws ContentStoreException {
                    return contentStore.getSpaceContents(space.getSpaceId());
                }

                public String getLogMessage() {
                    return "Error calling contentStore.getSpaceContents() for: " + space.getSpaceId();
                }
            };
            new Thread(new Runnable((StoreCaller)caller, itemCounterListener){
                final /* synthetic */ StoreCaller val$caller;
                final /* synthetic */ ItemCounter val$itemCounterListener;
                {
                    this.val$caller = storeCaller;
                    this.val$itemCounterListener = itemCounter;
                }

                @Override
                public void run() {
                    ExtendedIteratorCounterThread runnable = new ExtendedIteratorCounterThread((Iterator)this.val$caller.call(), (ExtendedCountListener)this.val$itemCounterListener);
                    runnable.run();
                }
            }).start();
        }
    }

    private String formatItemCountCacheKey(Space space) {
        return space.getStoreId() + "/" + space.getSpaceId() + "/itemCountListener";
    }

    private void expireItemCount(HttpServletRequest request, Space space) {
        String key = this.formatItemCountCacheKey(space);
        request.getSession().getServletContext().removeAttribute(key);
    }

    private Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ModelAndView addSpace(HttpServletRequest request, HttpServletResponse response, @Valid Space space, BindingResult result) throws Exception {
        String spaceId = space.getSpaceId();
        ContentStore contentStore = this.getContentStore(space);
        contentStore.createSpace(spaceId);
        if ("true".equals(request.getParameter("publicFlag"))) {
            HashMap<String, AclType> acls = new HashMap<String, AclType>();
            acls.put("group-public", AclType.READ);
            contentStore.setSpaceACLs(spaceId, acls);
        }
        this.populateSpace(space, contentStore.getSpace(spaceId, null, 0L, null), contentStore);
        return this.createModel(space);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ModelAndView delete(HttpServletRequest request, HttpServletResponse response, Space space, BindingResult result) throws Exception {
        String spaceId = space.getSpaceId();
        ContentStore contentStore = this.getContentStore(space);
        contentStore.deleteSpace(spaceId);
        return this.createModel(space);
    }

    private ModelAndView createModel(Space space) {
        return new ModelAndView("jsonView", "space", (Object)space);
    }

    protected ContentStore getContentStore(Space space) throws ContentStoreException {
        return this.contentStoreManager.getContentStore(space.getStoreId());
    }
}

