/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.control;

import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.duracloud.appconfig.domain.DuradminConfig;
import org.duracloud.appconfig.xml.DuradminInitDocumentBinding;
import org.duracloud.common.util.ExceptionUtil;
import org.duracloud.common.util.InitUtil;
import org.duracloud.duradmin.control.ControllerSupport;
import org.duracloud.duradmin.control.StorageSummaryCache;
import org.duracloud.duradmin.domain.AdminInit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/init"})
public class InitController {
    private static final String APP_NAME = "DurAdmin";
    private final Logger log = LoggerFactory.getLogger(InitController.class);
    private StorageSummaryCache storageSummaryCache;
    private ControllerSupport controllerSupport;

    @Autowired
    public InitController(ControllerSupport controllerSupport, StorageSummaryCache storageSummaryCache) {
        this.storageSummaryCache = storageSummaryCache;
        this.controllerSupport = controllerSupport;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView initialize(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.log.debug("Initializing DurAdmin");
        ServletInputStream xml = request.getInputStream();
        if (xml != null) {
            try {
                this.updateInit(DuradminInitDocumentBinding.createDuradminConfigFrom((InputStream)xml));
                return this.respond(response, "Initialization Successful\n", 200);
            }
            catch (Exception e) {
                return this.respond(response, ExceptionUtil.getStackTraceAsString((Throwable)e), 500);
            }
        }
        return this.respond(response, "no duradminConfig in request\n", 400);
    }

    private void updateInit(DuradminConfig config) throws Exception {
        AdminInit init = new AdminInit();
        init.setDuraStoreHost(config.getDurastoreHost());
        init.setDuraStorePort(config.getDurastorePort());
        init.setDuraStoreContext(config.getDurastoreContext());
        init.setAmaUrl(config.getAmaUrl());
        init.setDuraBossContext(config.getDurabossContext());
        init.setMillDbEnabled(config.isMillDbEnabled().booleanValue());
        org.duracloud.duradmin.config.DuradminConfig.setConfig((AdminInit)init);
        this.controllerSupport.getContentStoreManager().reinitialize(org.duracloud.duradmin.config.DuradminConfig.getDuraStoreHost(), org.duracloud.duradmin.config.DuradminConfig.getDuraStorePort(), org.duracloud.duradmin.config.DuradminConfig.getDuraStoreContext());
        this.storageSummaryCache.init();
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public ModelAndView isInitialized(HttpServletResponse response) {
        if (org.duracloud.duradmin.config.DuradminConfig.isInitialized()) {
            String text = InitUtil.getInitializedText((String)APP_NAME);
            return this.respond(response, text, 200);
        }
        String text = InitUtil.getNotInitializedText((String)APP_NAME);
        return this.respond(response, text, 503);
    }

    private ModelAndView respond(HttpServletResponse response, String msg, int status) {
        response.setStatus(status);
        this.log.info("writing response: status = " + status + "; msg = " + msg);
        return new ModelAndView("jsonView", "response", (Object)msg);
    }

    public void setStorageSummaryCache(StorageSummaryCache storageSummaryCache) {
        this.storageSummaryCache = storageSummaryCache;
    }
}

