/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.security;

import java.lang.reflect.Method;
import org.duracloud.common.error.NoUserLoggedInException;
import org.duracloud.common.model.Credential;
import org.duracloud.common.model.Securable;
import org.duracloud.security.context.SecurityContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.MethodBeforeAdvice;

public class SecurityAdvice
implements MethodBeforeAdvice {
    private final Logger log = LoggerFactory.getLogger(SecurityAdvice.class);
    private SecurityContextUtil securityContextUtil;

    public SecurityAdvice(SecurityContextUtil util) {
        this.securityContextUtil = util;
    }

    public void before(Method method, Object[] objects, Object o) throws Throwable {
        String methodClass = method.getDeclaringClass().getCanonicalName();
        String methodName = method.getName();
        this.log.debug("securing call: '" + methodClass + "." + methodName + "'");
        if (!Securable.class.isAssignableFrom(o.getClass())) {
            this.log.warn("Unexpected object filtered: " + o.getClass().getName());
            return;
        }
        Securable securable = (Securable)o;
        try {
            Credential credential = this.securityContextUtil.getCurrentUser();
            securable.login(credential);
        }
        catch (NoUserLoggedInException e) {
            this.log.info("No user currently logged in.");
            securable.logout();
        }
    }
}

