/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.spaces.controller;

import java.io.InputStream;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.lang.StringUtils;
import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManager;
import org.duracloud.duradmin.domain.ContentItem;
import org.duracloud.duradmin.spaces.controller.ContentItemController;
import org.duracloud.duradmin.spaces.controller.ContentItemUploadTask;
import org.duracloud.duradmin.util.SpaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ContentItemUploadController {
    protected final Logger log = LoggerFactory.getLogger(ContentItemUploadController.class);
    private ContentStoreManager contentStoreManager;

    @Autowired
    public ContentItemUploadController(@Qualifier(value="contentStoreManager") ContentStoreManager contentStoreManager) {
        this.contentStoreManager = contentStoreManager;
    }

    @RequestMapping(value={"/spaces/content/upload"}, method={RequestMethod.POST})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.log.debug("handling request...");
            ServletFileUpload upload = new ServletFileUpload();
            FileItemIterator iter = upload.getItemIterator(request);
            String spaceId = null;
            String storeId = null;
            String contentId = null;
            ArrayList<ContentItem> results = new ArrayList<ContentItem>();
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                if (item.isFormField()) {
                    String value = Streams.asString((InputStream)item.openStream(), (String)"UTF-8");
                    if (item.getFieldName().equals("spaceId")) {
                        this.log.debug("setting spaceId: {}", (Object)value);
                        spaceId = value;
                        continue;
                    }
                    if (item.getFieldName().equals("storeId")) {
                        storeId = value;
                        continue;
                    }
                    if (!item.getFieldName().equals("contentId")) continue;
                    contentId = value;
                    continue;
                }
                this.log.debug("setting fileStream: {}", (Object)item);
                if (StringUtils.isBlank(spaceId)) {
                    throw new IllegalArgumentException("space id required.");
                }
                ContentItem ci = new ContentItem();
                if (StringUtils.isBlank(contentId)) {
                    contentId = item.getName();
                }
                ci.setContentId(contentId);
                ci.setSpaceId(spaceId);
                ci.setStoreId(storeId);
                ci.setContentMimetype(item.getContentType());
                ContentStore contentStore = this.contentStoreManager.getContentStore(ci.getStoreId());
                ContentItemUploadTask task = new ContentItemUploadTask(ci, contentStore, item.openStream(), request.getUserPrincipal().getName());
                task.execute();
                ContentItem result = new ContentItem();
                Authentication auth = SecurityContextHolder.getContext().getAuthentication();
                SpaceUtil.populateContentItem(ContentItemController.getBaseURL(request), result, ci.getSpaceId(), ci.getContentId(), contentStore, auth);
                results.add(result);
                contentId = null;
            }
            return new ModelAndView("javascriptJsonView", "results", results);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }
}

