/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.control;

import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.duracloud.common.util.ExceptionUtil;
import org.duracloud.security.DuracloudUserDetailsService;
import org.duracloud.security.xml.SecurityUsersDocumentBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class InitSecurityUsersController {
    private final Logger log = LoggerFactory.getLogger(InitSecurityUsersController.class);
    private DuracloudUserDetailsService userDetailsService;

    @Autowired
    public InitSecurityUsersController(DuracloudUserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    @RequestMapping(value={"/security"}, method={RequestMethod.POST})
    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletInputStream xml = request.getInputStream();
        if (xml != null) {
            try {
                List users = SecurityUsersDocumentBinding.createSecurityUsersFrom((InputStream)xml);
                this.userDetailsService.setUsers(users);
                return this.respond(response, "Initialization Successful\n", 200);
            }
            catch (Exception e) {
                return this.respond(response, ExceptionUtil.getStackTraceAsString((Throwable)e), 500);
            }
        }
        return this.respond(response, "no users in request\n", 400);
    }

    private ModelAndView respond(HttpServletResponse response, String msg, int status) {
        response.setStatus(status);
        this.log.info("writing response: status = " + status + "; msg = " + msg);
        return new ModelAndView("jsonView", "response", (Object)msg);
    }
}

