/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.duckdb.DuckDBResultSetMetaData;
import org.duckdb.DuckDBVector;

public class DuckDBNative {
    protected static native ByteBuffer duckdb_jdbc_startup(byte[] var0, boolean var1);

    protected static native void duckdb_jdbc_shutdown(ByteBuffer var0);

    protected static native ByteBuffer duckdb_jdbc_connect(ByteBuffer var0);

    protected static native void duckdb_jdbc_set_auto_commit(ByteBuffer var0, boolean var1);

    protected static native boolean duckdb_jdbc_get_auto_commit(ByteBuffer var0);

    protected static native void duckdb_jdbc_disconnect(ByteBuffer var0);

    protected static native ByteBuffer duckdb_jdbc_prepare(ByteBuffer var0, byte[] var1);

    protected static native String duckdb_jdbc_prepare_type(ByteBuffer var0);

    protected static native void duckdb_jdbc_release(ByteBuffer var0);

    protected static native DuckDBResultSetMetaData duckdb_jdbc_meta(ByteBuffer var0);

    protected static native ByteBuffer duckdb_jdbc_execute(ByteBuffer var0, Object[] var1);

    protected static native void duckdb_jdbc_free_result(ByteBuffer var0);

    protected static native DuckDBVector[] duckdb_jdbc_fetch(ByteBuffer var0);

    protected static native int duckdb_jdbc_fetch_size();

    static {
        try {
            String string = "";
            String string2 = "";
            String string3 = System.getProperty("os.name").toLowerCase().trim();
            String string4 = System.getProperty("os.arch").toLowerCase().trim();
            if (string4.equals("x86_64") || string4.equals("amd64")) {
                string2 = "amd64";
            }
            if (string3.startsWith("windows")) {
                string = "windows";
            } else if (string3.startsWith("mac")) {
                string = "osx";
            } else if (string3.startsWith("linux")) {
                string = "linux";
            }
            String string5 = "/libduckdb_java.so_" + string + "_" + string2;
            Path path = Files.createTempFile("libduckdb_java", ".so", new FileAttribute[0]);
            URL uRL = DuckDBNative.class.getResource(string5);
            if (uRL == null) {
                throw new IOException(string5 + " not found");
            }
            Files.copy(uRL.openStream(), path, StandardCopyOption.REPLACE_EXISTING);
            new File(path.toString()).deleteOnExit();
            System.load(path.toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

