/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import org.duckdb.DuckDBNative;

public class DuckDBDatabase {
    protected String url;
    protected ByteBuffer db_ref;

    public DuckDBDatabase(String string) throws SQLException {
        if (!string.startsWith("jdbc:duckdb")) {
            throw new SQLException("DuckDB JDBC URL needs to start with 'jdbc:duckdb:'");
        }
        this.url = string;
        String string2 = string.replaceFirst("^jdbc:duckdb:", "").trim();
        if (string2.length() == 0) {
            string2 = ":memory:";
        }
        this.db_ref = DuckDBNative.duckdb_jdbc_startup(string2.getBytes(StandardCharsets.UTF_8), false);
    }

    protected synchronized void finalize() throws Throwable {
        if (this.db_ref != null) {
            DuckDBNative.duckdb_jdbc_shutdown(this.db_ref);
            this.db_ref = null;
        }
    }
}

