/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing.element;

import java.util.ArrayList;
import java.util.List;
import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.AbstractWingElement;
import org.dspace.app.xmlui.wing.element.Head;
import org.dspace.app.xmlui.wing.element.Reference;
import org.dspace.app.xmlui.wing.element.StructuralElement;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class ReferenceSet
extends AbstractWingElement
implements StructuralElement {
    public static final String E_REFERENCE_SET = "referenceSet";
    public static final String A_ORDER_BY = "orderBy";
    public static final String A_TYPE = "type";
    public static final String TYPE_SUMMARY_LIST = "summaryList";
    public static final String TYPE_SUMMARY_VIEW = "summaryView";
    public static final String TYPE_DETAIL_LIST = "detailList";
    public static final String TYPE_DETAIL_VIEW = "detailView";
    public static final String[] TYPES = new String[]{"summaryList", "summaryView", "detailList", "detailView"};
    private final String name;
    private final String orderBy;
    private final String type;
    private final String rend;
    private Head head;
    private List<AbstractWingElement> contents = new ArrayList();

    protected ReferenceSet(WingContext context, boolean childreference, String name, String type, String orderBy, String rend) throws WingException {
        super(context);
        if (!childreference) {
            this.require(name, "The 'name' parameter is required for reference sets.");
        }
        this.restrict(type, TYPES, "The 'method' parameter must be one of these values: 'summaryList', 'summaryView', 'detailList', or 'detailView'.");
        this.name = name;
        this.type = type;
        this.orderBy = orderBy;
        this.rend = rend;
    }

    public Head setHead() throws WingException {
        this.head = new Head(this.context, null);
        return this.head;
    }

    public void setHead(String characters) throws WingException {
        Head newHead = this.setHead();
        newHead.addContent(characters);
    }

    public void setHead(Message message) throws WingException {
        Head newHead = this.setHead();
        newHead.addContent(message);
    }

    public Reference addReference(Object object) throws WingException {
        Reference reference = new Reference(this.context, object);
        this.contents.add(reference);
        return reference;
    }

    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) throws SAXException {
        AttributeMap attributes = new AttributeMap();
        if (this.name != null) {
            attributes.put((Object)"n", (Object)this.name);
        }
        if (this.name != null) {
            attributes.put((Object)"id", (Object)this.context.generateID(E_REFERENCE_SET, this.name));
        }
        attributes.put((Object)A_TYPE, (Object)this.type);
        if (this.orderBy != null) {
            attributes.put((Object)A_ORDER_BY, (Object)this.orderBy);
        }
        if (this.rend != null) {
            attributes.put((Object)"rend", (Object)this.rend);
        }
        this.startElement(contentHandler, namespaces, E_REFERENCE_SET, attributes);
        if (this.head != null) {
            this.head.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        for (AbstractWingElement content : this.contents) {
            content.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        this.endElement(contentHandler, namespaces, E_REFERENCE_SET);
    }

    public void dispose() {
        if (this.contents != null) {
            for (AbstractWingElement content : this.contents) {
                content.dispose();
            }
            this.contents.clear();
        }
        this.contents = null;
        super.dispose();
    }
}

