/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.opensearch;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.dspace.app.xmlui.opensearch.AbstractOpenSearchGenerator;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.FeedUtils;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DiscoveryOpenSearchGenerator
extends AbstractOpenSearchGenerator
implements CacheableProcessingComponent,
Recyclable {
    private SearchService searchService = null;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.searchService = SearchUtils.getSearchService();
        if (this.searchService == null) {
            throw new IllegalStateException("Couldn't get a search service instance");
        }
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            if (this.resultsDoc == null) {
                Context context = ContextUtil.obtainContext((Map)this.objectModel);
                DiscoverQuery queryArgs = new DiscoverQuery();
                queryArgs.setQuery(this.query);
                queryArgs.setStart(this.start - 1);
                queryArgs.setMaxResults(this.rpp);
                queryArgs.setDSpaceObjectFilter(2);
                if (this.sort != null) {
                    String sortField = this.searchService.toSortFieldIndex(this.sort.getMetadata(), this.sort.getType());
                    if ("ASC".equals(this.sortOrder)) {
                        queryArgs.setSortField(sortField, DiscoverQuery.SORT_ORDER.asc);
                    } else {
                        queryArgs.setSortField(sortField, DiscoverQuery.SORT_ORDER.desc);
                    }
                }
                DiscoverResult queryResults = null;
                queryResults = this.scope == null ? SearchUtils.getSearchService().search(context, queryArgs) : SearchUtils.getSearchService().search(context, this.scope, queryArgs);
                List results = queryResults.getDspaceObjects();
                this.resultsDoc = this.openSearchService.getResultsDoc(context, this.format, this.query, (int)queryResults.getTotalSearchResults(), this.start, this.rpp, this.scope, results, FeedUtils.i18nLabels);
                FeedUtils.unmangleI18N((Document)this.resultsDoc);
            }
            DOMStreamer streamer = new DOMStreamer(this.contentHandler, this.lexicalHandler);
            streamer.stream((Node)this.resultsDoc);
        }
        catch (SQLException sqle) {
            throw new SAXException(sqle);
        }
        catch (SearchServiceException se) {
            throw new ProcessingException((Exception)((Object)se));
        }
    }

    public void recycle() {
        this.searchService = null;
        super.recycle();
    }
}

