/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.AbstractGenerator;
import org.dspace.app.xmlui.objectmanager.AbstractAdapter;
import org.dspace.app.xmlui.objectmanager.ContainerAdapter;
import org.dspace.app.xmlui.objectmanager.ItemAdapter;
import org.dspace.app.xmlui.objectmanager.RepositoryAdapter;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.xml.sax.SAXException;

public class DSpaceMETSGenerator
extends AbstractGenerator {
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            Context context = ContextUtil.obtainContext((Map)this.objectModel);
            AbstractAdapter adapter = this.resolveAdapter(context);
            if (adapter == null) {
                throw new ResourceNotFoundException("Unable to locate object.");
            }
            this.configureAdapter(adapter);
            this.contentHandler.startDocument();
            adapter.renderMETS(context, this.contentHandler, this.lexicalHandler);
            this.contentHandler.endDocument();
        }
        catch (WingException we) {
            throw new ProcessingException((Exception)((Object)we));
        }
        catch (CrosswalkException ce) {
            throw new ProcessingException((Exception)((Object)ce));
        }
        catch (SQLException sqle) {
            throw new ProcessingException((Exception)sqle);
        }
    }

    private AbstractAdapter resolveAdapter(Context context) throws SQLException {
        String[] parts;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String contextPath = request.getContextPath();
        String handle = this.parameters.getParameter("handle", null);
        String internal = this.parameters.getParameter("internal", null);
        ItemAdapter adapter = null;
        if (handle != null) {
            DSpaceObject dso = this.handleService.resolveToObject(context, handle);
            if (dso instanceof Item) {
                adapter = new ItemAdapter(context, (Item)dso, contextPath);
            } else if (dso instanceof Collection || dso instanceof Community) {
                adapter = new ContainerAdapter(context, dso, contextPath);
            }
        } else if (internal != null && (parts = internal.split(":")).length == 2) {
            String type = parts[0];
            String strid = parts[1];
            UUID id = null;
            if ("repository".equals(type)) {
                if (this.handleService.getPrefix().equals(strid)) {
                    adapter = new RepositoryAdapter(context, contextPath);
                }
            } else {
                Community community;
                id = UUID.fromString(parts[1]);
                if ("item".equals(type)) {
                    Item item = (Item)this.itemService.find(context, id);
                    if (item != null) {
                        adapter = new ItemAdapter(context, item, contextPath);
                    }
                } else if ("collection".equals(type)) {
                    Collection collection = (Collection)this.collectionService.find(context, id);
                    if (collection != null) {
                        adapter = new ContainerAdapter(context, (DSpaceObject)collection, contextPath);
                    }
                } else if ("community".equals(type) && (community = (Community)this.communityService.find(context, id)) != null) {
                    adapter = new ContainerAdapter(context, (DSpaceObject)community, contextPath);
                }
            }
        }
        return adapter;
    }

    public void configureAdapter(AbstractAdapter adapter) {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String sections = request.getParameter("sections");
        String dmdTypes = request.getParameter("dmdTypes");
        String techMDTypes = request.getParameter("techMDTypes");
        String rightsMDTypes = request.getParameter("rightsMDTypes");
        String sourceMDTypes = request.getParameter("sourceMDTypes");
        String digiprovMDTypes = request.getParameter("digiprovMDTypes");
        String fileGrpTypes = request.getParameter("fileGrpTypes");
        String structTypes = request.getParameter("structTypes");
        adapter.setSections(sections);
        adapter.setDmdTypes(dmdTypes);
        adapter.setTechMDTypes(techMDTypes);
        adapter.setRightsMDTypes(rightsMDTypes);
        adapter.setSourceMDTypes(sourceMDTypes);
        adapter.setDigiProvMDTypes(digiprovMDTypes);
        adapter.setFileGrpTypes(fileGrpTypes);
        adapter.setStructTypes(structTypes);
    }
}

