/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.xmlworkflow;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.state.actions.ActionInterface;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.xml.sax.SAXException;

public abstract class AbstractXMLUIAction
extends AbstractDSpaceTransformer
implements ActionInterface {
    protected static Logger log = Logger.getLogger(AbstractXMLUIAction.class);
    protected static final Message T_dspace_home = AbstractXMLUIAction.message((String)"xmlui.general.dspace_home");
    protected static final Message T_showfull = AbstractXMLUIAction.message((String)"xmlui.Submission.general.showfull");
    protected static final Message T_showsimple = AbstractXMLUIAction.message((String)"xmlui.Submission.general.showsimple");
    protected static final Message T_workflow_title = AbstractXMLUIAction.message((String)"xmlui.Submission.general.workflow.title");
    protected static final Message T_workflow_trail = AbstractXMLUIAction.message((String)"xmlui.Submission.general.workflow.trail");
    protected static final Message T_workflow_head = AbstractXMLUIAction.message((String)"xmlui.Submission.general.workflow.head");
    protected XmlWorkflowItem workflowItem;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        int id = parameters.getParameterAsInteger("workflowID", -1);
        try {
            this.workflowItem = (XmlWorkflowItem)XmlWorkflowServiceFactory.getInstance().getXmlWorkflowItemService().find(this.context, id);
        }
        catch (SQLException e) {
            log.error((Object)LogManager.getHeader((Context)this.context, (String)"Error while retrieving workflowitem", (String)("workflowitemid: " + id)), (Throwable)e);
            throw new ProcessingException("Error while retrieving workflowitem", (Throwable)e);
        }
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        super.addPageMeta(pageMeta);
        pageMeta.addMetadata("title").addContent(T_workflow_title);
        Collection collection = this.workflowItem.getCollection();
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        HandleUtil.buildHandleTrail((Context)this.context, (DSpaceObject)collection, (PageMeta)pageMeta, (String)this.contextPath, (boolean)true);
        pageMeta.addTrail().addContent(T_workflow_trail);
    }

    public abstract void addBody(Body var1) throws SAXException, WingException, SQLException, IOException, AuthorizeException;

    protected void addWorkflowItemInformation(Division div, Item item, Request request) throws WingException {
        String showfull = request.getParameter("submit_full_item_info");
        if (showfull != null && request.getParameter("submit_simple_item_info") != null) {
            showfull = null;
        }
        if (showfull == null) {
            ReferenceSet referenceSet = div.addReferenceSet("narf", "summaryView");
            referenceSet.setHead(T_workflow_head);
            referenceSet.addReference((Object)item);
            div.addPara().addButton("submit_full_item_info").setValue(T_showfull);
        } else {
            ReferenceSet referenceSet = div.addReferenceSet("narf", "detailView");
            referenceSet.setHead(T_workflow_head);
            referenceSet.addReference((Object)item);
            div.addPara().addButton("submit_simple_item_info").setValue(T_showsimple);
            div.addHidden("submit_full_item_info").setValue("true");
        }
    }
}

