/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.versioning;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.ProcessingException;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.factory.VersionServiceFactory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.service.VersioningService;
import org.xml.sax.SAXException;

public class VersionNoticeTransformer
extends AbstractDSpaceTransformer {
    private static final Message T_new_version_head = VersionNoticeTransformer.message((String)"xmlui.aspect.versioning.VersionNoticeTransformer.notice.new_version_head");
    private static final Message T_new_version_help = VersionNoticeTransformer.message((String)"xmlui.aspect.versioning.VersionNoticeTransformer.notice.new_version_help");
    private static final Message T_workflow_version_head = VersionNoticeTransformer.message((String)"xmlui.aspect.versioning.VersionNoticeTransformer.notice.workflow_version_head");
    private static final Message T_workflow_version_help = VersionNoticeTransformer.message((String)"xmlui.aspect.versioning.VersionNoticeTransformer.notice.workflow_version_help");
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected VersioningService versioningService = VersionServiceFactory.getInstance().getVersionService();
    protected VersionHistoryService versionHistoryService = VersionServiceFactory.getInstance().getVersionHistoryService();

    public void addBody(Body body) throws SAXException, WingException, SQLException, IOException, AuthorizeException, ProcessingException {
        Version latestVersion;
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (!(dso instanceof Item)) {
            return;
        }
        Item item = (Item)dso;
        if (item.isWithdrawn()) {
            return;
        }
        Division mainDivision = body.addDivision("item-view", "primary");
        String title = item.getName();
        if (title != null) {
            mainDivision.setHead(title);
        } else {
            mainDivision.setHead(item.getHandle());
        }
        VersionHistory history = this.versionHistoryService.findByItem(this.context, item);
        if (history != null && (latestVersion = this.retrieveLatestVersion(history, item)) != null && !latestVersion.getItem().equals((Object)item)) {
            Item latestVersionItem = latestVersion.getItem();
            if (latestVersionItem.isArchived()) {
                this.addVersionNotice(mainDivision, latestVersionItem, T_new_version_head, T_new_version_help, true);
            } else {
                this.addVersionNotice(mainDivision, latestVersionItem, T_workflow_version_head, T_workflow_version_help, false);
            }
        }
    }

    private Version retrieveLatestVersion(VersionHistory history, Item item) throws SQLException {
        List allVersions = this.versioningService.getVersionsByHistory(this.context, history);
        for (Version version : allVersions) {
            if (!version.getItem().isArchived() && !this.authorizeService.isAdmin(this.context, (DSpaceObject)item.getOwningCollection())) continue;
            return version;
        }
        return null;
    }

    protected void addVersionNotice(Division division, Item item, Message head, Message content, boolean addItemUrl) throws WingException, SQLException {
        Division noticeDiv = division.addDivision("general-message", "version-notice notice neutral");
        noticeDiv.setHead(head);
        Para para = noticeDiv.addPara();
        para.addContent(content);
        if (addItemUrl) {
            String url = this.handleService.resolveToURL(this.context, item.getHandle());
            para.addXref(url, url);
        }
    }
}

