/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission.submit;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.dspace.app.util.DCInput;
import org.dspace.app.util.DCInputSet;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.xmlui.aspect.submission.AbstractSubmissionStep;
import org.dspace.app.xmlui.aspect.submission.FlowUtils;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Composite;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Instance;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Radio;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.app.xmlui.wing.element.TextArea;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DCPersonName;
import org.dspace.content.DCSeriesNumber;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataValue;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.Choices;
import org.dspace.content.authority.factory.ContentAuthorityServiceFactory;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.content.authority.service.MetadataAuthorityService;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.I18nUtil;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.xml.sax.SAXException;

public class DescribeStep
extends AbstractSubmissionStep {
    protected static final Message T_head = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.head");
    protected static final Message T_unknown_field = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.unknown_field");
    protected static final Message T_required_field = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.required_field");
    protected static final Message T_last_name_help = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.last_name_help");
    protected static final Message T_first_name_help = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.first_name_help");
    protected static final Message T_year = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.year");
    protected static final Message T_month = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.month");
    protected static final Message T_day = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.day");
    protected static final Message T_series_name = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.series_name");
    protected static final Message T_report_no = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.report_no");
    private static final Message T_vocabulary_link = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.controlledvocabulary.link");
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected ChoiceAuthorityService choiceAuthorityService = ContentAuthorityServiceFactory.getInstance().getChoiceAuthorityService();
    protected MetadataAuthorityService metadataAuthorityService = ContentAuthorityServiceFactory.getInstance().getMetadataAuthorityService();
    protected DCInputsReader inputsReader = null;
    private static final String HINT_HTML_PREFIX = "<tr><td colspan=\"4\" class=\"submitFormHelp\">";
    private static final String HINT_HTML_POSTFIX = "</td></tr>";

    public DescribeStep() {
        this.requireSubmission = true;
        this.requireStep = true;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        String formFileName = I18nUtil.getInputFormsFileName((Locale)this.context.getCurrentLocale());
        try {
            this.inputsReader = org.dspace.submit.step.DescribeStep.getInputsReader((String)formFileName);
        }
        catch (ServletException e) {
            throw new ProcessingException((Exception)((Object)e));
        }
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        super.addPageMeta(pageMeta);
        UUID collectionID = this.submission.getCollection().getID();
        pageMeta.addMetadata("choice", "collection").addContent(String.valueOf(collectionID));
        pageMeta.addMetadata("stylesheet", "screen", "datatables", true).addContent("../../static/Datatables/DataTables-1.8.0/media/css/datatables.css");
        pageMeta.addMetadata("javascript", "static", "datatables", true).addContent("static/Datatables/DataTables-1.8.0/media/js/jquery.dataTables.min.js");
        pageMeta.addMetadata("stylesheet", "screen", "person-lookup", true).addContent("../../static/css/authority/person-lookup.css");
        pageMeta.addMetadata("javascript", null, "person-lookup", true).addContent("../../static/js/person-lookup.js");
        String jumpTo = this.submissionInfo.getJumpToField();
        if (jumpTo != null) {
            pageMeta.addMetadata("page", "jumpTo").addContent(jumpTo);
        }
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DCInput[] inputs;
        DCInputSet inputSet;
        org.dspace.content.Item item = this.submission.getItem();
        Collection collection = this.submission.getCollection();
        String actionURL = this.contextPath + "/handle/" + collection.getHandle() + "/submit/" + this.knot.getId() + ".continue";
        try {
            inputSet = this.inputsReader.getInputs(this.submission.getCollection().getHandle());
            inputs = inputSet.getPageRows(this.getPage() - 1, this.submission.hasMultipleTitles(), this.submission.isPublishedBefore());
        }
        catch (DCInputsReaderException se) {
            throw new UIException((Throwable)se);
        }
        Division div = body.addInteractiveDivision("submit-describe", actionURL, "post", "primary submission");
        div.setHead(T_submission_head);
        this.addSubmissionProgressList(div);
        org.dspace.app.xmlui.wing.element.List form = div.addList("submit-describe", "form");
        form.setHead(T_head);
        String documentType = "";
        if (this.itemService.getMetadataByMetadataString((DSpaceObject)item, "dc.type") != null && this.itemService.getMetadataByMetadataString((DSpaceObject)item, "dc.type").size() > 0) {
            documentType = ((MetadataValue)this.itemService.getMetadataByMetadataString((DSpaceObject)item, "dc.type").get(0)).getValue();
        }
        for (DCInput dcInput : inputs) {
            String scope = this.submissionInfo.isInWorkflow() ? "workflow" : "submit";
            boolean readonly = dcInput.isReadOnly(scope);
            if (!dcInput.isAllowedFor(documentType) || !dcInput.isVisible(scope) && !readonly) continue;
            String schema = dcInput.getSchema();
            String element = dcInput.getElement();
            String qualifier = dcInput.getQualifier();
            List dcValues = this.itemService.getMetadata((DSpaceObject)item, schema, element, qualifier, "*");
            String fieldName = FlowUtils.getFieldName((DCInput)dcInput);
            String inputType = dcInput.getInputType();
            String fieldKey = this.metadataAuthorityService.makeFieldKey(schema, element, qualifier);
            if (this.choiceAuthorityService.isChoicesConfigured(fieldKey) && "select".equals(this.choiceAuthorityService.getPresentation(fieldKey))) {
                this.renderChoiceSelectField(form, fieldName, collection, dcInput, dcValues, readonly);
                continue;
            }
            if (inputType.equals("name")) {
                this.renderNameField(form, fieldName, dcInput, dcValues, readonly);
                continue;
            }
            if (inputType.equals("date")) {
                this.renderDateField(form, fieldName, dcInput, dcValues, readonly);
                continue;
            }
            if (inputType.equals("series")) {
                this.renderSeriesField(form, fieldName, dcInput, dcValues, readonly);
                continue;
            }
            if (inputType.equals("twobox")) {
                this.renderOneboxField(form, fieldName, dcInput, dcValues, readonly);
                continue;
            }
            if (inputType.equals("qualdrop_value")) {
                List unfiltered = this.itemService.getMetadata((DSpaceObject)item, dcInput.getSchema(), dcInput.getElement(), "*", "*");
                ArrayList<MetadataValue> filtered = new ArrayList<MetadataValue>();
                for (MetadataValue dcValue : unfiltered) {
                    String unfilteredFieldName = dcValue.getMetadataField().getElement() + "." + dcValue.getMetadataField().getQualifier();
                    if (inputSet.isFieldPresent(unfilteredFieldName, documentType)) continue;
                    filtered.add(dcValue);
                }
                this.renderQualdropField(form, fieldName, dcInput, filtered, readonly);
                continue;
            }
            if (inputType.equals("textarea")) {
                this.renderTextArea(form, fieldName, dcInput, dcValues, readonly);
                continue;
            }
            if (inputType.equals("dropdown")) {
                this.renderDropdownField(form, fieldName, dcInput, dcValues, readonly);
                continue;
            }
            if (inputType.equals("list")) {
                this.renderSelectFromListField(form, fieldName, dcInput, dcValues, readonly);
                continue;
            }
            if (inputType.equals("onebox")) {
                this.renderOneboxField(form, fieldName, dcInput, dcValues, readonly);
                continue;
            }
            form.addItem(T_unknown_field);
        }
        this.addControlButtons(form);
    }

    public org.dspace.app.xmlui.wing.element.List addReviewSection(org.dspace.app.xmlui.wing.element.List reviewList) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DCInput[] inputs;
        org.dspace.app.xmlui.wing.element.List describeSection = reviewList.addList("submit-review-" + this.stepAndPage, "form");
        describeSection.setHead(T_head);
        DCInputSet inputSet = null;
        try {
            inputSet = this.inputsReader.getInputs(this.submission.getCollection().getHandle());
        }
        catch (DCInputsReaderException se) {
            throw new UIException((Throwable)se);
        }
        for (DCInput input : inputs = inputSet.getPageRows(this.getPage() - 1, this.submission.hasMultipleTitles(), this.submission.isPublishedBefore())) {
            String scope;
            String string = scope = this.submissionInfo.isInWorkflow() ? "workflow" : "submit";
            if (!input.isVisible(scope) && !input.isReadOnly(scope)) continue;
            String inputType = input.getInputType();
            String pairsName = input.getPairsType();
            List values = inputType.equals("qualdrop_value") ? this.itemService.getMetadata((DSpaceObject)this.submission.getItem(), input.getSchema(), input.getElement(), "*", "*") : this.itemService.getMetadata((DSpaceObject)this.submission.getItem(), input.getSchema(), input.getElement(), input.getQualifier(), "*");
            if (values == null || values.size() <= 0) continue;
            for (MetadataValue value : values) {
                String displayValue = null;
                if (inputType.equals("date")) {
                    DCDate date = new DCDate(value.getValue());
                    displayValue = date.toString();
                } else if (inputType.equals("dropdown")) {
                    displayValue = input.getDisplayString(pairsName, value.getValue());
                } else if (inputType.equals("qualdrop_value")) {
                    String qualifier = value.getMetadataField().getQualifier();
                    String displayQual = input.getDisplayString(pairsName, qualifier);
                    if (displayQual != null && displayQual.length() > 0) {
                        displayValue = displayQual + ":" + value.getValue();
                    }
                } else {
                    displayValue = value.getValue();
                }
                if (displayValue == null || displayValue.length() <= 0) continue;
                describeSection.addLabel(input.getLabel());
                if (this.metadataAuthorityService.isAuthorityControlled(value.getMetadataField())) {
                    String confidence = value.getAuthority() != null && value.getAuthority().length() > 0 ? Choices.getConfidenceText((int)value.getConfidence()).toLowerCase() : "blank";
                    Item authItem = describeSection.addItem("submit-review-field-with-authority", "ds-authority-confidence cf-" + confidence);
                    authItem.addContent(displayValue);
                    continue;
                }
                describeSection.addItem(displayValue);
            }
        }
        return describeSection;
    }

    private void renderNameField(org.dspace.app.xmlui.wing.element.List form, String fieldName, DCInput dcInput, List<MetadataValue> dcValues, boolean readonly) throws WingException {
        String fieldKey;
        boolean isAuthorityControlled;
        Composite fullName = form.addItem().addComposite(fieldName, "submit-name");
        Text lastName = fullName.addText(fieldName + "_last");
        Text firstName = fullName.addText(fieldName + "_first");
        fullName.setLabel(dcInput.getLabel());
        fullName.setHelp(this.cleanHints(dcInput.getHints()));
        if (dcInput.isRequired()) {
            fullName.setRequired();
        }
        if (this.isFieldInError(fieldName)) {
            if (dcInput.getWarning() != null && dcInput.getWarning().length() > 0) {
                fullName.addError(dcInput.getWarning());
            } else {
                fullName.addError(T_required_field);
            }
        }
        if (dcInput.isRepeatable() && !readonly) {
            fullName.enableAddOperation();
        }
        if ((dcInput.isRepeatable() || dcValues.size() > 1) && !readonly) {
            fullName.enableDeleteOperation();
        }
        if (isAuthorityControlled = this.metadataAuthorityService.isAuthorityControlled(fieldKey = this.metadataAuthorityService.makeFieldKey(dcInput.getSchema(), dcInput.getElement(), dcInput.getQualifier()))) {
            fullName.setAuthorityControlled();
            fullName.setAuthorityRequired(this.metadataAuthorityService.isAuthorityRequired(fieldKey));
        }
        if (this.choiceAuthorityService.isChoicesConfigured(fieldKey)) {
            fullName.setChoices(fieldKey);
            fullName.setChoicesPresentation(this.choiceAuthorityService.getPresentation(fieldKey));
            fullName.setChoicesClosed(this.choiceAuthorityService.isClosed(fieldKey));
        }
        lastName.setLabel(T_last_name_help);
        firstName.setLabel(T_first_name_help);
        if (readonly) {
            lastName.setDisabled();
            firstName.setDisabled();
            fullName.setDisabled();
        }
        if (dcInput.isRepeatable() || dcValues.size() > 1) {
            for (MetadataValue dcValue : dcValues) {
                DCPersonName dpn = new DCPersonName(dcValue.getValue());
                lastName.addInstance().setValue(dpn.getLastName());
                firstName.addInstance().setValue(dpn.getFirstNames());
                Instance fi = fullName.addInstance();
                fi.setValue(dcValue.getValue());
                if (!isAuthorityControlled) continue;
                if (dcValue.getAuthority() == null || dcValue.getAuthority().equals("")) {
                    fi.setAuthorityValue("", "blank");
                    continue;
                }
                fi.setAuthorityValue(dcValue.getAuthority(), Choices.getConfidenceText((int)dcValue.getConfidence()));
            }
        } else if (dcValues.size() == 1) {
            DCPersonName dpn = new DCPersonName(dcValues.get(0).getValue());
            lastName.setValue(dpn.getLastName());
            firstName.setValue(dpn.getFirstNames());
            if (isAuthorityControlled) {
                if (dcValues.get(0).getAuthority() == null || dcValues.get(0).getAuthority().equals("")) {
                    lastName.setAuthorityValue("", "blank");
                } else {
                    lastName.setAuthorityValue(dcValues.get(0).getAuthority(), Choices.getConfidenceText((int)dcValues.get(0).getConfidence()));
                }
            }
        }
    }

    private void renderDateField(org.dspace.app.xmlui.wing.element.List form, String fieldName, DCInput dcInput, List<MetadataValue> dcValues, boolean readonly) throws WingException {
        Composite fullDate = form.addItem().addComposite(fieldName, "submit-date");
        Text year = fullDate.addText(fieldName + "_year");
        Select month = fullDate.addSelect(fieldName + "_month");
        Text day = fullDate.addText(fieldName + "_day");
        fullDate.setLabel(dcInput.getLabel());
        fullDate.setHelp(this.cleanHints(dcInput.getHints()));
        if (dcInput.isRequired()) {
            fullDate.setRequired();
        }
        if (this.isFieldInError(fieldName)) {
            if (dcInput.getWarning() != null && dcInput.getWarning().length() > 0) {
                fullDate.addError(dcInput.getWarning());
            } else {
                fullDate.addError(T_required_field);
            }
        }
        if (dcInput.isRepeatable() && !readonly) {
            fullDate.enableAddOperation();
        }
        if ((dcInput.isRepeatable() || dcValues.size() > 1) && !readonly) {
            fullDate.enableDeleteOperation();
        }
        if (readonly) {
            year.setDisabled();
            month.setDisabled();
            day.setDisabled();
        }
        year.setLabel(T_year);
        year.setSize(4, 4);
        month.setLabel(T_month);
        month.addOption(0, "");
        for (int i = 1; i < 13; ++i) {
            month.addOption(i, DCDate.getMonthName((int)i, (Locale)Locale.getDefault()));
        }
        day.setLabel(T_day);
        day.setSize(2, 2);
        if (dcInput.isRepeatable() || dcValues.size() > 1) {
            for (MetadataValue dcValue : dcValues) {
                DCDate dcDate = new DCDate(dcValue.getValue());
                year.addInstance().setValue(String.valueOf(dcDate.getYear()));
                month.addInstance().setOptionSelected(dcDate.getMonth());
                day.addInstance().setValue(String.valueOf(dcDate.getDay()));
                fullDate.addInstance().setValue(dcDate.toString());
            }
        } else if (dcValues.size() == 1) {
            DCDate dcDate = new DCDate(dcValues.get(0).getValue());
            year.setValue(String.valueOf(dcDate.getYear()));
            month.setOptionSelected(dcDate.getMonth());
            if (dcDate.getDay() == -1) {
                day.setValue("");
            } else {
                day.setValue(String.valueOf(dcDate.getDay()));
            }
        }
    }

    private void renderSeriesField(org.dspace.app.xmlui.wing.element.List form, String fieldName, DCInput dcInput, List<MetadataValue> dcValues, boolean readonly) throws WingException {
        Composite fullSeries = form.addItem().addComposite(fieldName, "submit-" + dcInput.getInputType());
        Text series = fullSeries.addText(fieldName + "_series");
        Text number = fullSeries.addText(fieldName + "_number");
        fullSeries.setLabel(dcInput.getLabel());
        fullSeries.setHelp(this.cleanHints(dcInput.getHints()));
        if (dcInput.isRequired()) {
            fullSeries.setRequired();
        }
        if (this.isFieldInError(fieldName)) {
            if (dcInput.getWarning() != null && dcInput.getWarning().length() > 0) {
                fullSeries.addError(dcInput.getWarning());
            } else {
                fullSeries.addError(T_required_field);
            }
        }
        if (dcInput.isRepeatable() && !readonly) {
            fullSeries.enableAddOperation();
        }
        if ((dcInput.isRepeatable() || dcValues.size() > 1) && !readonly) {
            fullSeries.enableDeleteOperation();
        }
        series.setLabel(T_series_name);
        number.setLabel(T_report_no);
        if (readonly) {
            fullSeries.setDisabled();
            series.setDisabled();
            number.setDisabled();
        }
        if (dcInput.isRepeatable() || dcValues.size() > 1) {
            for (MetadataValue dcValue : dcValues) {
                DCSeriesNumber dcSeriesNumber = new DCSeriesNumber(dcValue.getValue());
                series.addInstance().setValue(dcSeriesNumber.getSeries());
                number.addInstance().setValue(dcSeriesNumber.getNumber());
                fullSeries.addInstance().setValue(dcSeriesNumber.toString());
            }
        } else if (dcValues.size() == 1) {
            DCSeriesNumber dcSeriesNumber = new DCSeriesNumber(dcValues.get(0).getValue());
            series.setValue(dcSeriesNumber.getSeries());
            number.setValue(dcSeriesNumber.getNumber());
        }
    }

    private void renderQualdropField(org.dspace.app.xmlui.wing.element.List form, String fieldName, DCInput dcInput, List<MetadataValue> dcValues, boolean readonly) throws WingException {
        Composite qualdrop = form.addItem().addComposite(fieldName, "submit-qualdrop");
        Select qual = qualdrop.addSelect(fieldName + "_qualifier");
        Text value = qualdrop.addText(fieldName + "_value");
        qualdrop.setLabel(dcInput.getLabel());
        qualdrop.setHelp(this.cleanHints(dcInput.getHints()));
        if (dcInput.isRequired()) {
            qualdrop.setRequired();
        }
        if (this.isFieldInError(fieldName)) {
            if (dcInput.getWarning() != null && dcInput.getWarning().length() > 0) {
                qualdrop.addError(dcInput.getWarning());
            } else {
                qualdrop.addError(T_required_field);
            }
        }
        if (dcInput.isRepeatable() && !readonly) {
            qualdrop.enableAddOperation();
        }
        if ((dcInput.isRepeatable() || dcValues.size() > 1) && !readonly) {
            qualdrop.enableDeleteOperation();
        }
        if (readonly) {
            qualdrop.setDisabled();
            qual.setDisabled();
            value.setDisabled();
        }
        List pairs = dcInput.getPairs();
        for (int i = 0; i < pairs.size(); i += 2) {
            String display = (String)pairs.get(i);
            String returnValue = (String)pairs.get(i + 1);
            qual.addOption(returnValue, display);
        }
        if (dcInput.isRepeatable() || dcValues.size() > 1) {
            for (MetadataValue dcValue : dcValues) {
                qual.addInstance().setOptionSelected(dcValue.getMetadataField().getQualifier());
                value.addInstance().setValue(dcValue.getValue());
                qualdrop.addInstance().setValue(dcValue.getMetadataField().getQualifier() + ":" + dcValue.getValue());
            }
        } else if (dcValues.size() == 1) {
            qual.setOptionSelected(dcValues.get(0).getMetadataField().getQualifier());
            value.setValue(dcValues.get(0).getValue());
        }
    }

    private void renderTextArea(org.dspace.app.xmlui.wing.element.List form, String fieldName, DCInput dcInput, List<MetadataValue> dcValues, boolean readonly) throws WingException {
        TextArea textArea = form.addItem().addTextArea(fieldName, "submit-textarea");
        textArea.setLabel(dcInput.getLabel());
        textArea.setHelp(this.cleanHints(dcInput.getHints()));
        String fieldKey = this.metadataAuthorityService.makeFieldKey(dcInput.getSchema(), dcInput.getElement(), dcInput.getQualifier());
        boolean isAuth = this.metadataAuthorityService.isAuthorityControlled(fieldKey);
        if (isAuth) {
            textArea.setAuthorityControlled();
            textArea.setAuthorityRequired(this.metadataAuthorityService.isAuthorityRequired(fieldKey));
        }
        if (this.choiceAuthorityService.isChoicesConfigured(fieldKey)) {
            textArea.setChoices(fieldKey);
            textArea.setChoicesPresentation(this.choiceAuthorityService.getPresentation(fieldKey));
            textArea.setChoicesClosed(this.choiceAuthorityService.isClosed(fieldKey));
        }
        if (dcInput.isRequired()) {
            textArea.setRequired();
        }
        if (this.isFieldInError(fieldName)) {
            if (dcInput.getWarning() != null && dcInput.getWarning().length() > 0) {
                textArea.addError(dcInput.getWarning());
            } else {
                textArea.addError(T_required_field);
            }
        }
        if (dcInput.isRepeatable() && !readonly) {
            textArea.enableAddOperation();
        }
        if ((dcInput.isRepeatable() || dcValues.size() > 1) && !readonly) {
            textArea.enableDeleteOperation();
        }
        if (readonly) {
            textArea.setDisabled();
        }
        if (dcInput.isRepeatable() || dcValues.size() > 1) {
            for (MetadataValue dcValue : dcValues) {
                Instance ti = textArea.addInstance();
                ti.setValue(dcValue.getValue());
                if (!isAuth) continue;
                if (dcValue.getAuthority() == null || dcValue.getAuthority().equals("")) {
                    ti.setAuthorityValue("", "blank");
                    continue;
                }
                ti.setAuthorityValue(dcValue.getAuthority(), Choices.getConfidenceText((int)dcValue.getConfidence()));
            }
        } else if (dcValues.size() == 1) {
            textArea.setValue(dcValues.get(0).getValue());
            if (isAuth) {
                if (dcValues.get(0).getAuthority() == null || dcValues.get(0).getAuthority().equals("")) {
                    textArea.setAuthorityValue("", "blank");
                } else {
                    textArea.setAuthorityValue(dcValues.get(0).getAuthority(), Choices.getConfidenceText((int)dcValues.get(0).getConfidence()));
                }
            }
        }
    }

    private void renderChoiceSelectField(org.dspace.app.xmlui.wing.element.List form, String fieldName, Collection coll, DCInput dcInput, List<MetadataValue> dcValues, boolean readonly) throws WingException {
        String fieldKey = this.metadataAuthorityService.makeFieldKey(dcInput.getSchema(), dcInput.getElement(), dcInput.getQualifier());
        if (this.metadataAuthorityService.isAuthorityControlled(fieldKey)) {
            throw new WingException("Field " + fieldKey + " has choice presentation of type \"" + "select" + "\", it may NOT be authority-controlled.");
        }
        Select select = form.addItem().addSelect(fieldName, "submit-select");
        select.setLabel(dcInput.getLabel());
        select.setHelp(this.cleanHints(dcInput.getHints()));
        if (dcInput.isRequired()) {
            select.setRequired();
        }
        if (this.isFieldInError(fieldName)) {
            if (dcInput.getWarning() != null && dcInput.getWarning().length() > 0) {
                select.addError(dcInput.getWarning());
            } else {
                select.addError(T_required_field);
            }
        }
        if (dcInput.isRepeatable() || dcValues.size() > 1) {
            select.setMultiple();
            select.setSize(6);
        } else {
            select.setSize(1);
        }
        if (readonly) {
            select.setDisabled();
        }
        Choices cs = this.choiceAuthorityService.getMatches(fieldKey, "", coll, 0, 0, null);
        if (dcValues.size() == 0) {
            select.addOption(true, "", "");
        }
        for (Choice c : cs.values) {
            select.addOption(c.value, c.label);
        }
        for (MetadataValue dcValue : dcValues) {
            select.setOptionSelected(dcValue.getValue());
        }
    }

    private void renderDropdownField(org.dspace.app.xmlui.wing.element.List form, String fieldName, DCInput dcInput, List<MetadataValue> dcValues, boolean readonly) throws WingException {
        Select select = form.addItem().addSelect(fieldName, "submit-select");
        select.setLabel(dcInput.getLabel());
        select.setHelp(this.cleanHints(dcInput.getHints()));
        if (dcInput.isRequired()) {
            select.setRequired();
        }
        if (this.isFieldInError(fieldName)) {
            if (dcInput.getWarning() != null && dcInput.getWarning().length() > 0) {
                select.addError(dcInput.getWarning());
            } else {
                select.addError(T_required_field);
            }
        }
        if (dcInput.isRepeatable() || dcValues.size() > 1) {
            select.setMultiple();
            select.setSize(6);
        }
        if (readonly) {
            select.setDisabled();
        }
        List pairs = dcInput.getPairs();
        for (int i = 0; i < pairs.size(); i += 2) {
            String display = (String)pairs.get(i);
            String value = (String)pairs.get(i + 1);
            select.addOption(value, display);
        }
        for (MetadataValue dcValue : dcValues) {
            select.setOptionSelected(dcValue.getValue());
        }
    }

    private void renderSelectFromListField(org.dspace.app.xmlui.wing.element.List form, String fieldName, DCInput dcInput, List<MetadataValue> dcValues, boolean readonly) throws WingException {
        Object listField = null;
        listField = dcInput.isRepeatable() ? form.addItem().addCheckBox(fieldName) : form.addItem().addRadio(fieldName);
        if (readonly) {
            listField.setDisabled();
        }
        listField.setLabel(dcInput.getLabel());
        listField.setHelp(this.cleanHints(dcInput.getHints()));
        if (dcInput.isRequired()) {
            listField.setRequired();
        }
        if (this.isFieldInError(fieldName)) {
            if (dcInput.getWarning() != null && dcInput.getWarning().length() > 0) {
                listField.addError(dcInput.getWarning());
            } else {
                listField.addError(T_required_field);
            }
        }
        List pairs = dcInput.getPairs();
        for (int i = 0; i < pairs.size(); i += 2) {
            String display = (String)pairs.get(i);
            String value = (String)pairs.get(i + 1);
            if (listField instanceof CheckBox) {
                listField.addOption(value, display);
                continue;
            }
            if (!(listField instanceof Radio)) continue;
            ((Radio)listField).addOption(value, display);
        }
        for (MetadataValue dcValue : dcValues) {
            if (listField instanceof CheckBox) {
                listField.setOptionSelected(dcValue.getValue());
                continue;
            }
            if (!(listField instanceof Radio)) continue;
            ((Radio)listField).setOptionSelected(dcValue.getValue());
        }
    }

    private void renderOneboxField(org.dspace.app.xmlui.wing.element.List form, String fieldName, DCInput dcInput, List<MetadataValue> dcValues, boolean readonly) throws WingException {
        Item item = form.addItem();
        Text text = item.addText(fieldName, "submit-text");
        if (dcInput.getVocabulary() != null) {
            String vocabularyUrl = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.url");
            vocabularyUrl = vocabularyUrl + "/JSON/controlled-vocabulary?vocabularyIdentifier=" + dcInput.getVocabulary();
            vocabularyUrl = vocabularyUrl + "&metadataFieldName=" + fieldName;
            item.addXref("vocabulary:" + vocabularyUrl).addContent(T_vocabulary_link);
        }
        text.setLabel(dcInput.getLabel());
        text.setHelp(this.cleanHints(dcInput.getHints()));
        String fieldKey = this.metadataAuthorityService.makeFieldKey(dcInput.getSchema(), dcInput.getElement(), dcInput.getQualifier());
        boolean isAuth = this.metadataAuthorityService.isAuthorityControlled(fieldKey);
        if (isAuth) {
            text.setAuthorityControlled();
            text.setAuthorityRequired(this.metadataAuthorityService.isAuthorityRequired(fieldKey));
        }
        if (this.choiceAuthorityService.isChoicesConfigured(fieldKey)) {
            text.setChoices(fieldKey);
            text.setChoicesPresentation(this.choiceAuthorityService.getPresentation(fieldKey));
            text.setChoicesClosed(this.choiceAuthorityService.isClosed(fieldKey));
        }
        if (dcInput.isRequired()) {
            text.setRequired();
        }
        if (this.isFieldInError(fieldName)) {
            if (dcInput.getWarning() != null && dcInput.getWarning().length() > 0) {
                text.addError(dcInput.getWarning());
            } else {
                text.addError(T_required_field);
            }
        }
        if (dcInput.isRepeatable() && !readonly) {
            text.enableAddOperation();
        }
        if ((dcInput.isRepeatable() || dcValues.size() > 1) && !readonly) {
            text.enableDeleteOperation();
        }
        if (readonly) {
            text.setDisabled();
        }
        if (dcInput.isRepeatable() || dcValues.size() > 1) {
            for (MetadataValue dcValue : dcValues) {
                Instance ti = text.addInstance();
                ti.setValue(dcValue.getValue());
                if (!isAuth) continue;
                if (dcValue.getAuthority() == null || dcValue.getAuthority().equals("")) {
                    ti.setAuthorityValue("", "blank");
                    continue;
                }
                ti.setAuthorityValue(dcValue.getAuthority(), Choices.getConfidenceText((int)dcValue.getConfidence()));
            }
        } else if (dcValues.size() == 1) {
            text.setValue(dcValues.get(0).getValue());
            if (isAuth) {
                if (dcValues.get(0).getAuthority() == null || dcValues.get(0).getAuthority().equals("")) {
                    text.setAuthorityValue("", "blank");
                } else {
                    text.setAuthorityValue(dcValues.get(0).getAuthority(), Choices.getConfidenceText((int)dcValues.get(0).getConfidence()));
                }
            }
        }
    }

    private boolean isFieldInError(String fieldName) {
        return this.errorFields.contains(fieldName);
    }

    private String cleanHints(String dirtyHints) {
        String clean;
        String string = clean = dirtyHints != null ? dirtyHints : "";
        if (clean.startsWith(HINT_HTML_PREFIX)) {
            clean = clean.substring(HINT_HTML_PREFIX.length());
        }
        if (clean.endsWith(HINT_HTML_POSTFIX)) {
            clean = clean.substring(0, clean.length() - HINT_HTML_POSTFIX.length());
        }
        return clean;
    }

    public void recycle() {
        super.recycle();
        this.inputsReader = null;
    }
}

