/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.statistics;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.dspace.app.util.Util;
import org.dspace.app.xmlui.aspect.statistics.AbstractStatisticsDataTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.statistics.content.DatasetGenerator;
import org.dspace.statistics.content.DatasetTypeGenerator;
import org.dspace.statistics.content.StatisticsData;
import org.dspace.statistics.content.StatisticsDataWorkflow;
import org.dspace.statistics.content.StatisticsTable;
import org.dspace.statistics.content.filter.StatisticsFilter;
import org.dspace.statistics.content.filter.StatisticsSolrDateFilter;
import org.xml.sax.SAXException;

public class StatisticsWorkflowTransformer
extends AbstractStatisticsDataTransformer {
    private static final Message T_dspace_home = StatisticsWorkflowTransformer.message((String)"xmlui.general.dspace_home");
    private static final Message T_trail = StatisticsWorkflowTransformer.message((String)"xmlui.statistics.trail-workflow");
    private static final Message T_head_title = StatisticsWorkflowTransformer.message((String)"xmlui.statistics.workflow.title");
    private static final Message T_title = StatisticsWorkflowTransformer.message((String)"xmlui.statistics.workflow.title");
    private static final Message T_retrieval_error = StatisticsWorkflowTransformer.message((String)"xmlui.statistics.workflow.error");
    private static final Message T_no_results = StatisticsWorkflowTransformer.message((String)"xmlui.statistics.workflow.no-results");
    private static final Message T_workflow_head = StatisticsWorkflowTransformer.message((String)"xmlui.statistics.workflow.head");
    private static final Message T_workflow_head_dso = StatisticsWorkflowTransformer.message((String)"xmlui.statistics.workflow.head-dso");

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        if (dso != null) {
            HandleUtil.buildHandleTrail((Context)this.context, (DSpaceObject)dso, (PageMeta)pageMeta, (String)this.contextPath);
        }
        pageMeta.addTrailLink(this.contextPath + (dso != null && dso.getHandle() != null ? "/handle/" + dso.getHandle() : "") + "/workflow-statistics", T_trail);
        pageMeta.addMetadata("title").addContent(T_head_title);
    }

    public void addBody(Body body) throws SAXException, WingException, SQLException, IOException, AuthorizeException, ProcessingException {
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String selectedTimeFilter = request.getParameter("time_filter");
        StringBuilder actionPath = new StringBuilder().append(this.contextPath);
        if (dso != null) {
            actionPath.append("/handle/").append(dso.getHandle());
        }
        actionPath.append("/workflow-statistics");
        Division mainDivision = body.addInteractiveDivision("workflow-statistics", actionPath.toString(), "post", null);
        if (dso != null) {
            mainDivision.setHead(T_workflow_head_dso.parameterize(new Object[]{dso.getName()}));
        } else {
            mainDivision.setHead(T_workflow_head);
        }
        try {
            Division workflowTermsDivision = mainDivision.addDivision("workflow-terms");
            workflowTermsDivision.setHead(T_title);
            this.addTimeFilter(workflowTermsDivision);
            StatisticsSolrDateFilter dateFilter = this.getDateFilter(selectedTimeFilter);
            int time_filter = -1;
            if (request.getParameter("time_filter") != null && !"".equals(request.getParameter("time_filter"))) {
                time_filter = Math.abs(Util.getIntParameter((HttpServletRequest)request, (String)"time_filter"));
            }
            StatisticsTable statisticsTable = new StatisticsTable((StatisticsData)new StatisticsDataWorkflow(dso, time_filter));
            DatasetTypeGenerator queryGenerator = new DatasetTypeGenerator();
            queryGenerator.setType("previousWorkflowStep");
            queryGenerator.setMax(10);
            statisticsTable.addDatasetGenerator((DatasetGenerator)queryGenerator);
            if (dateFilter != null) {
                statisticsTable.addFilter((StatisticsFilter)dateFilter);
            }
            this.addDisplayTable(workflowTermsDivision, statisticsTable, true, new String[]{"xmlui.statistics.display.table.workflow.step."});
        }
        catch (Exception e) {
            mainDivision.addPara().addContent(T_retrieval_error);
        }
    }

    protected Message getNoResultsMessage() {
        return T_no_results;
    }
}

