/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.general;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.matching.Matcher;
import org.apache.cocoon.sitemap.PatternException;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.content.DSpaceObject;

public class HandleTypeMatcher
extends AbstractLogEnabled
implements Matcher {
    public static final String COMMUNITY_EXPRESSION = "community";
    public static final String COLLECITON_EXPRESSION = "collection";
    public static final String ITEM_EXPRESSION = "item";

    public Map match(String pattern, Map objectModel, Parameters parameters) throws PatternException {
        String[] expressions;
        for (String expression : expressions = pattern.split(",")) {
            if (COMMUNITY_EXPRESSION.equals(expression) || COLLECITON_EXPRESSION.equals(expression) || ITEM_EXPRESSION.equals(expression)) continue;
            this.getLogger().warn("Invalid test pattern, '" + pattern + "', encountered.");
            return null;
        }
        DSpaceObject dso = null;
        try {
            dso = HandleUtil.obtainHandle((Map)objectModel);
        }
        catch (SQLException sqle) {
            throw new PatternException("Unable to obtain DSpace Object", (Throwable)sqle);
        }
        if (dso == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String expression : expressions) {
            if (ITEM_EXPRESSION.equals(expression) && dso.getType() == 2) {
                result.put("type", ITEM_EXPRESSION);
                return result;
            }
            if (COLLECITON_EXPRESSION.equals(expression) && dso.getType() == 3) {
                result.put("type", COLLECITON_EXPRESSION);
                return result;
            }
            if (!COMMUNITY_EXPRESSION.equals(expression) || dso.getType() != 4) continue;
            result.put("type", COMMUNITY_EXPRESSION);
            return result;
        }
        return null;
    }
}

