/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.aspect.discovery.DiscoveryUIUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class CSVExportDiscoveryNavigation
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(CSVExportDiscoveryNavigation.class);
    private static final Message T_context_head = CSVExportDiscoveryNavigation.message((String)"xmlui.administrative.Navigation.context_head");
    private static final Message T_export_metadata = CSVExportDiscoveryNavigation.message((String)"xmlui.administrative.Navigation.context_search_export_metadata");
    private AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();

    public Serializable getKey() {
        try {
            Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
            String key = request.getScheme() + request.getServerName() + request.getServerPort() + request.getSitemapURI() + request.getQueryString();
            DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
            if (dso != null) {
                key = key + "-" + dso.getHandle();
            }
            return Long.valueOf(HashUtil.hash((String)key));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void addOptions(Options options) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Context context = ContextUtil.obtainContext((Map)this.objectModel);
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        options.addList("discovery");
        options.addList("browse");
        options.addList("account");
        options.addList("administrative");
        String uri = request.getSitemapURI();
        String search_export_config = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("xmlui.search.metadata_export");
        String query = CSVExportDiscoveryNavigation.decodeFromURL((String)request.getParameter("query"));
        String scope = request.getParameter("scope");
        String filters = "";
        String[] fqs = DiscoveryUIUtils.getFilterQueries((Request)ObjectModelHelper.getRequest((Map)this.objectModel), (Context)context);
        if (fqs != null) {
            for (int i = 0; i < fqs.length; ++i) {
                filters = i < fqs.length - 1 ? filters + fqs[i] + "," : filters + fqs[i];
            }
        }
        if (this.isEmpty(scope)) {
            scope = "/";
        }
        if (this.isEmpty(query)) {
            query = "*";
        }
        if (uri.contains("handle")) {
            scope = uri.replace("handle/", "").replace("/discover", "");
        }
        try {
            scope = scope.replace("/", "~");
        }
        catch (NullPointerException i) {
            // empty catch block
        }
        if (search_export_config != null) {
            log.info((Object)("uri: " + uri));
            log.info((Object)("query: " + query));
            log.info((Object)("scope: " + scope));
            log.info((Object)("filters: " + filters));
            boolean show = false;
            if (search_export_config.equals("admin")) {
                if (this.authorizeService.isAdmin(context)) {
                    show = true;
                }
            } else if (search_export_config.equals("user") || search_export_config.equals("anonymous")) {
                show = true;
            }
            if (show) {
                List results = options.addList("context");
                results.setHead(T_context_head);
                String link = this.contextPath + "/discover/search/csv?query=" + query + "&scope=" + scope;
                if (!this.isEmpty(filters)) {
                    link = link + "&filters=" + filters;
                }
                results.addItem().addXref(link, T_export_metadata);
            }
        }
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("search", "simpleURL").addContent("/discover");
        pageMeta.addMetadata("search", "advancedURL").addContent(this.contextPath + "/discover");
        pageMeta.addMetadata("search", "queryField").addContent("query");
    }
}

