/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.controlpanel;

import java.util.Map;
import org.apache.cocoon.Constants;
import org.apache.excalibur.store.Store;
import org.dspace.app.xmlui.aspect.administrative.controlpanel.AbstractControlPanelTab;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.List;

public class ControlPanelJavaTab
extends AbstractControlPanelTab {
    private static final Message T_JAVA_HEAD = ControlPanelJavaTab.message((String)"xmlui.administrative.ControlPanel.java_head");
    private static final Message T_JAVA_VERSION = ControlPanelJavaTab.message((String)"xmlui.administrative.ControlPanel.java_version");
    private static final Message T_JAVA_VENDOR = ControlPanelJavaTab.message((String)"xmlui.administrative.ControlPanel.java_vendor");
    private static final Message T_OS_NAME = ControlPanelJavaTab.message((String)"xmlui.administrative.ControlPanel.os_name");
    private static final Message T_OS_ARCH = ControlPanelJavaTab.message((String)"xmlui.administrative.ControlPanel.os_arch");
    private static final Message T_OS_VERSION = ControlPanelJavaTab.message((String)"xmlui.administrative.ControlPanel.os_version");
    private static final Message T_RUNTIME_HEAD = ControlPanelJavaTab.message((String)"xmlui.administrative.ControlPanel.runtime_head");
    private static final Message T_RUNTIME_PROCESSORS = ControlPanelJavaTab.message((String)"xmlui.administrative.ControlPanel.runtime_processors");
    private static final Message T_RUNTIME_MAX = ControlPanelJavaTab.message((String)"xmlui.administrative.ControlPanel.runtime_max");
    private static final Message T_RUNTIME_TOTAL = ControlPanelJavaTab.message((String)"xmlui.administrative.ControlPanel.runtime_total");
    private static final Message T_RUNTIME_USED = ControlPanelJavaTab.message((String)"xmlui.administrative.ControlPanel.runtime_used");
    private static final Message T_RUNTIME_FREE = ControlPanelJavaTab.message((String)"xmlui.administrative.ControlPanel.runtime_free");
    private static final Message T_COCOON_HEAD = ControlPanelJavaTab.message((String)"xmlui.administrative.ControlPanel.cocoon_head");
    private static final Message T_COCOON_VERSION = ControlPanelJavaTab.message((String)"xmlui.administrative.ControlPanel.cocoon_version");
    private static final Message T_COCOON_CACHE_DIR = ControlPanelJavaTab.message((String)"xmlui.administrative.ControlPanel.cocoon_cache_dir");
    private static final Message T_COCOON_WORK_DIR = ControlPanelJavaTab.message((String)"xmlui.administrative.ControlPanel.cocoon_work_dir");
    private static final Message T_COCOON_MAIN_CACHE_SIZE = ControlPanelJavaTab.message((String)"xmlui.administrative.ControlPanel.cocoon_main_cache_size");
    private static final Message T_COCOON_PERSISTENT_CACHE_SIZE = ControlPanelJavaTab.message((String)"xmlui.administrative.ControlPanel.cocoon_persistent_cache_size");
    private static final Message T_COCOON_TRANS_CACHE_SIZE = ControlPanelJavaTab.message((String)"xmlui.administrative.ControlPanel.cocoon_transient_cache_size");
    private static final Message T_COCOON_CACHE_CLEAR = ControlPanelJavaTab.message((String)"xmlui.administrative.ControlPanel.cocoon_cache_clear");

    public void addBody(Map objectModel, Division div) throws WingException {
        int processors = Runtime.getRuntime().availableProcessors();
        long maxMemory = Runtime.getRuntime().maxMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        maxMemory = maxMemory / 1024L / 1024L;
        totalMemory = totalMemory / 1024L / 1024L;
        usedMemory = usedMemory / 1024L / 1024L;
        freeMemory = freeMemory / 1024L / 1024L;
        List list = div.addList("javaOs");
        list.setHead(T_JAVA_HEAD);
        list.addLabel(T_JAVA_VERSION);
        list.addItem(System.getProperty("java.version"));
        list.addLabel(T_JAVA_VENDOR);
        list.addItem(System.getProperty("java.vm.name"));
        list.addLabel(T_OS_NAME);
        list.addItem(System.getProperty("os.name"));
        list.addLabel(T_OS_ARCH);
        list.addItem(System.getProperty("os.arch"));
        list.addLabel(T_OS_VERSION);
        list.addItem(System.getProperty("os.version"));
        List runtime = div.addList("runtime");
        runtime.setHead(T_RUNTIME_HEAD);
        runtime.addLabel(T_RUNTIME_PROCESSORS);
        runtime.addItem(String.valueOf(processors));
        runtime.addLabel(T_RUNTIME_MAX);
        runtime.addItem(String.valueOf(maxMemory) + " MiB");
        runtime.addLabel(T_RUNTIME_TOTAL);
        runtime.addItem(String.valueOf(totalMemory) + " MiB");
        runtime.addLabel(T_RUNTIME_USED);
        runtime.addItem(String.valueOf(usedMemory) + " MiB");
        runtime.addLabel(T_RUNTIME_FREE);
        runtime.addItem(String.valueOf(freeMemory) + " MiB");
        this.addCocoonInformation(div);
    }

    private void addCocoonInformation(Division div) throws WingException {
        String storeName;
        List cocoon = div.addList("cocoon");
        cocoon.setHead(T_COCOON_HEAD);
        cocoon.addLabel(T_COCOON_VERSION);
        cocoon.addItem(Constants.VERSION);
        if (this.settings != null) {
            cocoon.addLabel(T_COCOON_WORK_DIR);
            cocoon.addItem(this.settings.getWorkDirectory());
            cocoon.addLabel(T_COCOON_CACHE_DIR);
            cocoon.addItem(this.settings.getCacheDirectory());
        }
        if (this.storeDefault != null) {
            storeName = this.storeDefault.getClass().getName();
            storeName = storeName.substring(storeName.lastIndexOf(".") + 1);
            cocoon.addLabel(T_COCOON_MAIN_CACHE_SIZE.parameterize(new Object[]{storeName + ", 0x" + Integer.toHexString(this.storeDefault.hashCode())}));
            Item defaultSize = cocoon.addItem();
            defaultSize.addContent(String.valueOf(this.storeDefault.size()) + "  ");
            defaultSize.addXref(this.web_link + "&clearcache=true", T_COCOON_CACHE_CLEAR);
        }
        if (this.storePersistent != null) {
            storeName = this.storeDefault.getClass().getName();
            storeName = storeName.substring(storeName.lastIndexOf(".") + 1);
            cocoon.addLabel(T_COCOON_PERSISTENT_CACHE_SIZE.parameterize(new Object[]{storeName + ", 0x" + Integer.toHexString(this.storePersistent.hashCode())}));
            cocoon.addItem(String.valueOf(this.storePersistent.size()));
        }
        if (this.storeJanitor != null) {
            for (Store store : this.storeJanitor) {
                String storeName2 = store.getClass().getName();
                storeName2 = storeName2.substring(storeName2.lastIndexOf(".") + 1);
                cocoon.addLabel(T_COCOON_TRANS_CACHE_SIZE.parameterize(new Object[]{storeName2 + ", 0x" + Integer.toHexString(store.hashCode())}));
                cocoon.addItem(String.valueOf(store.size()));
            }
        }
    }
}

