/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.authorization;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.time.DateFormatUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Highlight;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.eperson.Group;

public class EditItemPolicies
extends AbstractDSpaceTransformer {
    private static final Message T_title = EditItemPolicies.message((String)"xmlui.administrative.authorization.EditItemPolicies.title");
    private static final Message T_policyList_trail = EditItemPolicies.message((String)"xmlui.administrative.authorization.general.policyList_trail");
    private static final Message T_authorize_trail = EditItemPolicies.message((String)"xmlui.administrative.authorization.general.authorize_trail");
    private static final Message T_main_head = EditItemPolicies.message((String)"xmlui.administrative.authorization.EditItemPolicies.main_head");
    private static final Message T_main_para1 = EditItemPolicies.message((String)"xmlui.administrative.authorization.EditItemPolicies.main_para1");
    private static final Message T_main_para2 = EditItemPolicies.message((String)"xmlui.administrative.authorization.EditItemPolicies.main_para2");
    private static final Message T_subhead_item = EditItemPolicies.message((String)"xmlui.administrative.authorization.EditItemPolicies.subhead_item");
    private static final Message T_subhead_bundle = EditItemPolicies.message((String)"xmlui.administrative.authorization.EditItemPolicies.subhead_bundle");
    private static final Message T_subhead_bitstream = EditItemPolicies.message((String)"xmlui.administrative.authorization.EditItemPolicies.subhead_bitstream");
    private static final Message T_add_itemPolicy_link = EditItemPolicies.message((String)"xmlui.administrative.authorization.EditItemPolicies.add_itemPolicy_link");
    private static final Message T_add_bundlePolicy_link = EditItemPolicies.message((String)"xmlui.administrative.authorization.EditItemPolicies.add_bundlePolicy_link");
    private static final Message T_add_bitstreamPolicy_link = EditItemPolicies.message((String)"xmlui.administrative.authorization.EditItemPolicies.add_bitstreamPolicy_link");
    private static final Message T_head_id = EditItemPolicies.message((String)"xmlui.administrative.authorization.EditContainerPolicies.head_id");
    private static final Message T_head_action = EditItemPolicies.message((String)"xmlui.administrative.authorization.EditContainerPolicies.head_action");
    private static final Message T_head_group = EditItemPolicies.message((String)"xmlui.administrative.authorization.EditContainerPolicies.head_group");
    private static final Message T_head_name = EditItemPolicies.message((String)"xmlui.administrative.authorization.EditContainerPolicies.head_name");
    private static final Message T_head_start_date = EditItemPolicies.message((String)"xmlui.administrative.authorization.EditContainerPolicies.head_start_date");
    private static final Message T_head_end_date = EditItemPolicies.message((String)"xmlui.administrative.authorization.EditContainerPolicies.head_end_date");
    private static final Message T_group_edit = EditItemPolicies.message((String)"xmlui.administrative.authorization.EditContainerPolicies.group_edit");
    private static final Message T_submit_delete = EditItemPolicies.message((String)"xmlui.administrative.authorization.EditContainerPolicies.submit_delete");
    private static final Message T_submit_return = EditItemPolicies.message((String)"xmlui.general.return");
    private static final Message T_no_policies = EditItemPolicies.message((String)"xmlui.administrative.authorization.EditContainerPolicies.no_policies");
    private static final Message T_dspace_home = EditItemPolicies.message((String)"xmlui.general.dspace_home");
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected ResourcePolicyService resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/authorize", T_authorize_trail);
        pageMeta.addTrail().addContent(T_policyList_trail);
    }

    public void addBody(Body body) throws WingException, SQLException {
        UUID itemID = UUID.fromString(this.parameters.getParameter("itemID", null));
        int highlightID = this.parameters.getParameterAsInteger("highlightID", -1);
        String baseURL = this.contextPath + "/admin/epeople?administrative-continue=" + this.knot.getId();
        Item item = (Item)this.itemService.find(this.context, itemID);
        List bundles = item.getBundles();
        ArrayList itemPolicies = (ArrayList)this.authorizeService.getPolicies(this.context, (DSpaceObject)item);
        Division main = body.addInteractiveDivision("edit-item-policies", this.contextPath + "/admin/authorize", "post", "primary administrative authorization");
        main.setHead(T_main_head.parameterize(new Object[]{item.getHandle(), item.getID()}));
        main.addPara().addHighlight("italic").addContent(T_main_para1);
        main.addPara().addHighlight("italic").addContent(T_main_para2);
        Table table = main.addTable("policies-confirm-delete", itemPolicies.size() + 3, 8);
        Row header = table.addRow("header");
        header.addCell();
        header.addCell().addContent(T_head_id);
        header.addCell().addContent(T_head_name);
        header.addCell().addContent(T_head_action);
        header.addCell().addContent(T_head_group);
        header.addCell();
        header.addCell().addContent(T_head_start_date);
        header.addCell().addContent(T_head_end_date);
        Row subheader = table.addRow(null, "header", "subheader");
        subheader.addCell(1, 7).addHighlight("bold").addContent(T_subhead_item);
        subheader.addCell().addHighlight("bold").addXref(baseURL + "&submit_add_item", T_add_itemPolicy_link);
        this.rowBuilder(baseURL, table, (List)itemPolicies, item.getID(), 2, highlightID);
        for (Bundle bundle : bundles) {
            subheader = table.addRow(null, "header", "subheader");
            subheader.addCell(null, null, 1, 7, "indent").addHighlight("bold").addContent(T_subhead_bundle.parameterize(new Object[]{bundle.getName(), bundle.getID()}));
            subheader.addCell().addHighlight("bold").addXref(baseURL + "&submit_add_bundle_" + bundle.getID(), T_add_bundlePolicy_link);
            ArrayList bundlePolicies = (ArrayList)this.authorizeService.getPolicies(this.context, (DSpaceObject)bundle);
            this.rowBuilder(baseURL, table, (List)bundlePolicies, bundle.getID(), 1, highlightID);
            List bitstreams = bundle.getBitstreams();
            for (Bitstream bitstream : bitstreams) {
                subheader = table.addRow(null, "header", "subheader");
                subheader.addCell(null, null, 1, 7, "doubleIndent").addContent(T_subhead_bitstream.parameterize(new Object[]{bitstream.getName(), bitstream.getID()}));
                subheader.addCell().addXref(baseURL + "&submit_add_bitstream_" + bitstream.getID(), T_add_bitstreamPolicy_link);
                ArrayList bitstreamPolicies = (ArrayList)this.authorizeService.getPolicies(this.context, (DSpaceObject)bitstream);
                this.rowBuilder(baseURL, table, (List)bitstreamPolicies, bitstream.getID(), 0, highlightID);
            }
        }
        Para buttons = main.addPara();
        buttons.addButton("submit_delete").setValue(T_submit_delete);
        buttons.addButton("submit_return").setValue(T_submit_return);
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }

    private void rowBuilder(String baseURL, Table table, List<ResourcePolicy> policies, UUID objectID, int objectType, int highlightID) throws WingException, SQLException {
        if (policies == null || policies.size() == 0) {
            table.addRow().addCell(1, 8).addHighlight("italic").addContent(T_no_policies);
        } else {
            for (ResourcePolicy policy : policies) {
                Row row = policy.getID() == highlightID ? table.addRow(null, null, "highlight") : table.addRow();
                Cell cell = objectType == 1 ? row.addCell(null, null, "indent") : (objectType == 0 ? row.addCell(null, null, "doubleIndent") : row.addCell());
                CheckBox select = cell.addCheckBox("select_policy");
                select.setLabel(String.valueOf(policy.getID()));
                select.addOption(String.valueOf(policy.getID()));
                Group policyGroup = policy.getGroup();
                row.addCell().addXref(baseURL + "&submit_edit&policy_id=" + policy.getID() + "&object_id=" + objectID + "&object_type=" + objectType, String.valueOf(policy.getID()));
                String name = "";
                if (policy.getRpName() != null) {
                    name = policy.getRpName();
                }
                row.addCell().addContent(name);
                row.addCell().addXref(baseURL + "&submit_edit&policy_id=" + policy.getID() + "&object_id=" + objectID + "&object_type=" + objectType, this.resourcePolicyService.getActionText(policy));
                if (policyGroup != null) {
                    Cell groupCell = row.addCell(1, 2);
                    groupCell.addContent(policyGroup.getName());
                    Highlight groupHigh = groupCell.addHighlight("fade");
                    groupHigh.addContent(" [");
                    groupHigh.addXref(baseURL + "&submit_edit_group&group_id=" + policyGroup.getID(), T_group_edit);
                    groupHigh.addContent("]");
                } else {
                    row.addCell(1, 2).addContent("...");
                }
                if (policy.getStartDate() != null) {
                    row.addCell().addContent(DateFormatUtils.format((Date)policy.getStartDate(), (String)"yyyy-MM-dd"));
                } else {
                    row.addCell().addContent("");
                }
                if (policy.getEndDate() != null) {
                    row.addCell().addContent(DateFormatUtils.format((Date)policy.getEndDate(), (String)"yyyy-MM-dd"));
                    continue;
                }
                row.addCell().addContent("");
            }
        }
    }
}

