/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.dspace.app.xmlui.aspect.administrative.SystemwideAlerts;
import org.dspace.harvest.factory.HarvestServiceFactory;
import org.dspace.harvest.service.HarvestSchedulingService;

public class ControlPanelAction
extends AbstractAction {
    protected HarvestSchedulingService harvestSchedulingService = HarvestServiceFactory.getInstance().getHarvestSchedulingService();

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String message = request.getParameter("message");
        String countdownString = request.getParameter("countdown");
        String restrictsessions = request.getParameter("restrictsessions");
        int countdown = -1;
        if (countdownString != null) {
            try {
                countdown = Integer.valueOf(countdownString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (message != null) {
            SystemwideAlerts.setMessage((String)message);
        }
        if (countdown >= 0) {
            countdown = countdown * 60 * 1000;
            long countDownTo = System.currentTimeMillis() + (long)countdown;
            SystemwideAlerts.setCountDownToo((long)countDownTo);
        }
        if (restrictsessions != null && restrictsessions.length() > 0) {
            try {
                int newState = Integer.valueOf(restrictsessions);
                SystemwideAlerts.setRestrictSessions((int)newState);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (request.getParameter("submit_activate") != null) {
            SystemwideAlerts.activateAlert();
            return new HashMap();
        }
        if (request.getParameter("submit_deactivate") != null) {
            SystemwideAlerts.deactivateAlert();
        } else if (request.getParameter("submit_harvest_start") != null) {
            this.harvestSchedulingService.startNewScheduler();
        } else if (request.getParameter("submit_harvest_resume") != null) {
            this.harvestSchedulingService.resumeScheduler();
        } else if (request.getParameter("submit_harvest_pause") != null) {
            this.harvestSchedulingService.pauseScheduler();
        } else if (request.getParameter("submit_harvest_stop") != null) {
            this.harvestSchedulingService.stopScheduler();
        } else if (request.getParameter("submit_harvest_reset") != null) {
            this.harvestSchedulingService.resetScheduler();
        }
        return null;
    }
}

