/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.workflow;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.cocoon.environment.Request;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReader;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.handle.HandleManager;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowManager;

/*
 * Exception performing whole class analysis ignored.
 */
public class FlowUtils {
    private static final Logger log = Logger.getLogger(FlowUtils.class);

    public static boolean processApproveTask(Context context, String id) throws SQLException, UIException, ServletException, AuthorizeException, IOException {
        WorkflowItem workflowItem = FlowUtils.findWorkflow((Context)context, (String)id);
        Item item = workflowItem.getItem();
        WorkflowManager.advance((Context)context, (WorkflowItem)workflowItem, (EPerson)context.getCurrentUser());
        String handle = HandleManager.findHandle((Context)context, (DSpaceObject)item);
        context.commit();
        return handle != null;
    }

    public static void processUnclaimTask(Context context, String id) throws SQLException, UIException, ServletException, AuthorizeException, IOException {
        WorkflowItem workflowItem = FlowUtils.findWorkflow((Context)context, (String)id);
        WorkflowManager.unclaim((Context)context, (WorkflowItem)workflowItem, (EPerson)context.getCurrentUser());
        context.commit();
        log.info((Object)LogManager.getHeader((Context)context, (String)"unclaim_workflow", (String)("workflow_item_id=" + workflowItem.getID() + ",item_id=" + workflowItem.getItem().getID() + ",collection_id=" + workflowItem.getCollection().getID() + ",new_state=" + workflowItem.getState())));
    }

    public static void processClaimTask(Context context, String id) throws SQLException, UIException, ServletException, AuthorizeException, IOException {
        WorkflowItem workflowItem = FlowUtils.findWorkflow((Context)context, (String)id);
        if (workflowItem.getState() != 1 && workflowItem.getState() != 3 && workflowItem.getState() != 5) {
            throw new AuthorizeException("Error while claiming task: this task has already been claimed !");
        }
        WorkflowManager.claim((Context)context, (WorkflowItem)workflowItem, (EPerson)context.getCurrentUser());
        context.commit();
        log.info((Object)LogManager.getHeader((Context)context, (String)"claim_task", (String)("workflow_item_id=" + workflowItem.getID() + "item_id=" + workflowItem.getItem().getID() + "collection_id=" + workflowItem.getCollection().getID() + "newowner_id=" + workflowItem.getOwner().getID() + "new_state=" + workflowItem.getState())));
    }

    public static void authorizeWorkflowItem(Context context, String workflowItemId) throws AuthorizeException, SQLException {
        WorkflowItem workflowItem = WorkflowItem.find((Context)context, (int)Integer.parseInt(workflowItemId.substring(1)));
        if ((workflowItem.getState() == 2 || workflowItem.getState() == 4 || workflowItem.getState() == 6) && workflowItem.getOwner().getID() != context.getCurrentUser().getID()) {
            throw new AuthorizeException("You are not allowed to perform this task.");
        }
        if (workflowItem.getState() == 1 || workflowItem.getState() == 3 || workflowItem.getState() == 5) {
            boolean hasPooledTask = false;
            List pooledTasks = WorkflowManager.getPooledTasks((Context)context, (EPerson)context.getCurrentUser());
            for (WorkflowItem pooledItem : pooledTasks) {
                if (pooledItem.getID() != workflowItem.getID()) continue;
                hasPooledTask = true;
            }
            if (!hasPooledTask) {
                throw new AuthorizeException("You are not allowed to perform this task.");
            }
        }
    }

    public static String processRejectTask(Context context, String id, Request request) throws SQLException, UIException, ServletException, AuthorizeException, IOException {
        WorkflowItem workflowItem = FlowUtils.findWorkflow((Context)context, (String)id);
        String reason = request.getParameter("reason");
        if (reason != null && reason.length() > 1) {
            WorkspaceItem wsi = WorkflowManager.reject((Context)context, (WorkflowItem)workflowItem, (EPerson)context.getCurrentUser(), (String)reason);
            Collection c = wsi.getCollection();
            SubmissionConfigReader subConfigReader = new SubmissionConfigReader();
            SubmissionConfig subConfig = subConfigReader.getSubmissionConfig(c.getHandle(), false);
            int lastStep = subConfig.getNumberOfSteps() - 2;
            wsi.setStageReached(lastStep);
            wsi.setPageReached(Integer.MAX_VALUE);
            wsi.update();
            context.commit();
            log.info((Object)LogManager.getHeader((Context)context, (String)"reject_workflow", (String)("workflow_item_id=" + wsi.getID() + "item_id=" + wsi.getItem().getID() + "collection_id=" + wsi.getCollection().getID() + "eperson_id=" + context.getCurrentUser().getID())));
            return null;
        }
        return "reason";
    }

    public static WorkflowItem findWorkflow(Context context, String inProgressSubmissionID) throws SQLException, AuthorizeException, IOException {
        int id = Integer.valueOf(inProgressSubmissionID.substring(1));
        return WorkflowItem.find((Context)context, (int)id);
    }
}

