/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.viewArtifacts;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.util.Util;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.I18nUtil;
import org.xml.sax.SAXException;

public class Navigation
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    public Serializable getKey() {
        try {
            Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
            String key = request.getScheme() + request.getServerName() + request.getServerPort() + request.getSitemapURI() + request.getQueryString();
            DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
            if (dso != null) {
                key = key + "-" + dso.getHandle();
            }
            return Long.valueOf(HashUtil.hash((String)key));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void addOptions(Options options) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        options.addList("browse");
        options.addList("account");
        options.addList("context");
        options.addList("administrative");
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        String analyticsKey;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        pageMeta.addMetadata("contextPath").addContent(this.contextPath);
        pageMeta.addMetadata("request", "queryString").addContent(request.getQueryString());
        pageMeta.addMetadata("request", "scheme").addContent(request.getScheme());
        pageMeta.addMetadata("request", "serverPort").addContent(request.getServerPort());
        pageMeta.addMetadata("request", "serverName").addContent(request.getServerName());
        pageMeta.addMetadata("request", "URI").addContent(request.getSitemapURI());
        String dspaceVersion = Util.getSourceVersion();
        if (dspaceVersion != null) {
            pageMeta.addMetadata("dspace", "version").addContent(dspaceVersion);
        }
        if ((analyticsKey = ConfigurationManager.getProperty((String)"xmlui.google.analytics.key")) != null && analyticsKey.length() > 0) {
            analyticsKey = analyticsKey.trim();
            pageMeta.addMetadata("google", "analytics").addContent(analyticsKey);
        }
        if (ConfigurationManager.getBooleanProperty((String)"websvc.opensearch.autolink")) {
            pageMeta.addMetadata("opensearch", "shortName").addContent(ConfigurationManager.getProperty((String)"websvc.opensearch.shortname"));
            pageMeta.addMetadata("opensearch", "autolink").addContent("open-search/description.xml");
        }
        pageMeta.addMetadata("page", "contactURL").addContent(this.contextPath + "/contact");
        pageMeta.addMetadata("page", "feedbackURL").addContent(this.contextPath + "/feedback");
        Locale[] locales = I18nUtil.getSupportedLocales();
        for (int i = 0; i < locales.length; ++i) {
            pageMeta.addMetadata("page", "supportedLocale").addContent(locales[i].toString());
            pageMeta.addMetadata("supportedLocale", locales[i].toString()).addContent(locales[i].getDisplayName(locales[i]));
        }
        pageMeta.addMetadata("page", "currentLocale").addContent(this.context.getCurrentLocale().toString());
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (dso != null) {
            if (dso instanceof Item) {
                pageMeta.addMetadata("focus", "object").addContent("hdl:" + dso.getHandle());
                this.getObjectManager().manageObject((Object)dso);
                dso = ((Item)dso).getOwningCollection();
            }
            if (dso instanceof Collection || dso instanceof Community) {
                pageMeta.addMetadata("focus", "container").addContent("hdl:" + dso.getHandle());
                this.getObjectManager().manageObject((Object)dso);
            }
        }
    }
}

