/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing.element;

import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.AbstractWingElement;
import org.dspace.app.xmlui.wing.element.RichTextContainer;
import org.dspace.app.xmlui.wing.element.StructuralElement;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class Cell
extends RichTextContainer
implements StructuralElement {
    public static final String E_CELL = "cell";
    public static final String A_ROLE = "role";
    public static final String A_ROWS = "rows";
    public static final String A_COLS = "cols";
    private String name;
    private String role;
    private int rows;
    private int cols;
    private String rend;
    public static final String ROLE_DATA = "data";
    public static final String ROLE_HEADER = "header";
    public static final String[] ROLES = new String[]{"data", "header"};

    protected Cell(WingContext context, String name, String role, int rows, int cols, String rend) throws WingException {
        super(context);
        this.restrict(role, ROLES, "The 'role' parameter must be one of these values: 'data' or 'header'.");
        this.greater(rows, -1, "The 'rows' parameter must be greater than or equal to zero.");
        this.greater(cols, -1, "The 'cols' parameter must be greater than or equal to zero.");
        this.name = name;
        this.role = role;
        this.rows = rows;
        this.cols = cols;
        this.rend = rend;
    }

    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) throws SAXException {
        AttributeMap attributes = new AttributeMap();
        if (this.name != null) {
            attributes.put((Object)"n", (Object)this.name);
            attributes.put((Object)"id", (Object)this.context.generateID(E_CELL, this.name));
        }
        if (this.role != null) {
            attributes.put((Object)A_ROLE, (Object)this.role);
        }
        if (this.rows > 0) {
            attributes.put(A_ROWS, this.rows);
        }
        if (this.cols > 0) {
            attributes.put(A_COLS, this.cols);
        }
        if (this.rend != null) {
            attributes.put((Object)"rend", (Object)this.rend);
        }
        this.startElement(contentHandler, namespaces, E_CELL, attributes);
        super.toSAX(contentHandler, lexicalHandler, namespaces);
        this.endElement(contentHandler, namespaces, E_CELL);
    }

    public void dispose() {
        if (this.contents != null) {
            for (AbstractWingElement content : this.contents) {
                content.dispose();
            }
            this.contents.clear();
        }
        this.contents = null;
        super.dispose();
    }
}

