/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon.servlet.multipart;

import java.io.IOException;
import java.io.PushbackInputStream;
import org.apache.cocoon.servlet.multipart.MultipartException;

class DSpaceTokenStream
extends PushbackInputStream {
    public static final int STATE_NOBOUNDARY = -1;
    public static final int STATE_NEXTPART = -2;
    public static final int STATE_ENDMULTIPART = -3;
    public static final int STATE_ENDOFSTREAM = -4;
    public static final int STATE_READING = -5;
    private PushbackInputStream in = null;
    private byte[] boundary = null;
    private int state = -1;

    public DSpaceTokenStream(PushbackInputStream in) {
        this(in, 1);
    }

    public DSpaceTokenStream(PushbackInputStream in, int size) {
        super(in, size);
        this.in = in;
    }

    public void setBoundary(byte[] boundary) throws MultipartException {
        this.boundary = boundary;
        if (this.state == -1) {
            this.state = -5;
        }
    }

    public void nextPart() throws MultipartException {
        if (this.state != -2) {
            throw new MultipartException("Illegal state");
        }
        this.state = -5;
    }

    public int getState() {
        return this.state;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int readToBoundary(byte[] out) throws IOException {
        if (this.state != -5) {
            return 0;
        }
        int boundaryIndex = 0;
        int written = 0;
        int b = this.in.read();
        while (true) {
            if ((byte)b != this.boundary[0]) {
                if (b == -1) {
                    this.state = -4;
                    return written;
                }
                out[written++] = (byte)b;
                if (written == out.length) {
                    return written;
                }
                b = this.in.read();
                continue;
            }
            for (boundaryIndex = 0; boundaryIndex < this.boundary.length && (byte)b == this.boundary[boundaryIndex]; ++boundaryIndex) {
                b = this.in.read();
            }
            if (boundaryIndex == this.boundary.length) {
                if (b != -1) {
                    if (b == 13) {
                        this.state = -2;
                        this.in.read();
                        return written;
                    } else {
                        if (b != 45) throw new IOException("Unexpected character after boundary");
                        this.state = -3;
                        this.in.read();
                        this.in.read();
                        this.in.read();
                    }
                    return written;
                } else {
                    this.state = -4;
                }
                return written;
            }
            if (b != -1) {
                this.in.unread(b);
            }
            this.in.unread(this.boundary, 1, boundaryIndex - 1);
            out[written++] = this.boundary[0];
            if (written == out.length) {
                return written;
            }
            b = this.in.read();
        }
    }

    @Override
    public int read(byte[] out) throws IOException {
        if (this.state != -5) {
            return 0;
        }
        return this.readToBoundary(out);
    }

    @Override
    public int read(byte[] out, int off, int len) throws IOException {
        if (off < 0 || off >= out.length) {
            throw new IOException("Buffer offset outside buffer");
        }
        if (off + len >= out.length) {
            throw new IOException("Buffer end outside buffer");
        }
        if (len < 0) {
            throw new IOException("Length must be a positive integer");
        }
        byte[] buf = new byte[len];
        int read = this.read(buf);
        if (read > 0) {
            System.arraycopy(buf, 0, out, off, read);
        }
        return read;
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int read = this.read(buf);
        if (read == 0) {
            return -1;
        }
        return buf[0];
    }
}

