/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.eperson.EPerson;

public class SendFeedbackAction
extends AbstractAction {
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String page = request.getParameter("page");
        String address = request.getParameter("email");
        String agent = request.getHeader("User-Agent");
        String session = request.getSession().getId();
        String comments = request.getParameter("comments");
        String fromPage = request.getHeader("Referer");
        String host = ConfigurationManager.getProperty((String)"dspace.hostname");
        String allowedReferrersString = ConfigurationManager.getProperty((String)"mail.allowed.referrers");
        String[] allowedReferrersSplit = null;
        boolean validReferral = false;
        if (allowedReferrersString != null && allowedReferrersString.length() > 0) {
            allowedReferrersSplit = allowedReferrersString.trim().split("\\s*,\\s*");
            for (int i = 0; i < allowedReferrersSplit.length; ++i) {
                if (fromPage.indexOf(allowedReferrersSplit[i]) == -1) continue;
                validReferral = true;
                break;
            }
        }
        String basicHost = "";
        if ("localhost".equals(host) || "127.0.0.1".equals(host) || host.equals(InetAddress.getLocalHost().getHostAddress())) {
            basicHost = host;
        } else {
            int lastDot = host.lastIndexOf(46);
            basicHost = host.substring(host.substring(0, lastDot).lastIndexOf(46));
        }
        if (fromPage == null || fromPage.indexOf(basicHost) == -1 && !validReferral) {
            throw new AuthorizeException(I18nUtil.getMessage((String)"feedback.error.forbidden"));
        }
        Context context = ContextUtil.obtainContext((Map)objectModel);
        EPerson loggedin = context.getCurrentUser();
        String eperson = null;
        if (loggedin != null) {
            eperson = loggedin.getEmail();
        }
        if (page == null || page.equals("")) {
            page = fromPage;
        }
        if (address == null || address.equals("") || comments == null || comments.equals("")) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("page", page);
            if (address == null || address.equals("")) {
                map.put("email", eperson);
            } else {
                map.put("email", address);
            }
            map.put("comments", comments);
            return map;
        }
        Email email = ConfigurationManager.getEmail((String)I18nUtil.getEmailFilename((Locale)context.getCurrentLocale(), (String)"feedback"));
        email.addRecipient(ConfigurationManager.getProperty((String)"feedback.recipient"));
        email.addArgument((Object)new Date());
        email.addArgument((Object)address);
        email.addArgument((Object)eperson);
        email.addArgument((Object)page);
        email.addArgument((Object)agent);
        email.addArgument((Object)session);
        email.addArgument((Object)comments);
        email.setReplyTo(address);
        email.send();
        return null;
    }
}

